/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ChannelsEnumValue {
    public static final ChannelsEnumValue EMAIL = new ChannelsEnumValue("email");
    public static final ChannelsEnumValue SMS = new ChannelsEnumValue("sms");
    public static final ChannelsEnumValue WEB_PUSH = new ChannelsEnumValue("web_push");
    public static final ChannelsEnumValue IOS_PUSH = new ChannelsEnumValue("ios_push");
    public static final ChannelsEnumValue ANDROID_PUSH = new ChannelsEnumValue("android_push");
    public static final ChannelsEnumValue UNKNOWN = new ChannelsEnumValue("unknown");
    public static final ChannelsEnumValue UNMAPPED_VALUE = new ChannelsEnumValue("unmapped_value");
    private static final Map<String, ChannelsEnumValue> values = ChannelsEnumValue.createValuesMap();
    private static final Map<String, ChannelsEnumValueEnum> enums = ChannelsEnumValue.createEnumsMap();
    private final String value;

    private ChannelsEnumValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static ChannelsEnumValue of(String value) {
        Class<ChannelsEnumValue> clazz = ChannelsEnumValue.class;
        synchronized (ChannelsEnumValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ChannelsEnumValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<ChannelsEnumValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelsEnumValue other = (ChannelsEnumValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ChannelsEnumValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelsEnumValue[] values() {
        Class<ChannelsEnumValue> clazz = ChannelsEnumValue.class;
        synchronized (ChannelsEnumValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ChannelsEnumValue[0]);
        }
    }

    private static final Map<String, ChannelsEnumValue> createValuesMap() {
        LinkedHashMap<String, ChannelsEnumValue> map = new LinkedHashMap<String, ChannelsEnumValue>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ChannelsEnumValueEnum> createEnumsMap() {
        HashMap<String, ChannelsEnumValueEnum> map = new HashMap<String, ChannelsEnumValueEnum>();
        map.put("email", ChannelsEnumValueEnum.EMAIL);
        map.put("sms", ChannelsEnumValueEnum.SMS);
        map.put("web_push", ChannelsEnumValueEnum.WEB_PUSH);
        map.put("ios_push", ChannelsEnumValueEnum.IOS_PUSH);
        map.put("android_push", ChannelsEnumValueEnum.ANDROID_PUSH);
        map.put("unknown", ChannelsEnumValueEnum.UNKNOWN);
        map.put("unmapped_value", ChannelsEnumValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ChannelsEnumValueEnum {
        EMAIL("email"),
        SMS("sms"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ChannelsEnumValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

