/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.GuideSectionMeta;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class Config {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="warning")
    private JsonNullable<String> warning;
    @JsonProperty(value="sections")
    private List<GuideSectionMeta> sections;

    @JsonCreator
    public Config(@JsonProperty(value="warning") JsonNullable<String> warning, @JsonProperty(value="sections") List<GuideSectionMeta> sections) {
        Utils.checkNotNull(warning, "warning");
        Utils.checkNotNull(sections, "sections");
        this.warning = warning;
        this.sections = sections;
    }

    public Config(List<GuideSectionMeta> sections) {
        this((JsonNullable<String>)JsonNullable.undefined(), sections);
    }

    @JsonIgnore
    public JsonNullable<String> warning() {
        return this.warning;
    }

    @JsonIgnore
    public List<GuideSectionMeta> sections() {
        return this.sections;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Config withWarning(String warning) {
        Utils.checkNotNull(warning, "warning");
        this.warning = JsonNullable.of((Object)warning);
        return this;
    }

    public Config withWarning(JsonNullable<String> warning) {
        Utils.checkNotNull(warning, "warning");
        this.warning = warning;
        return this;
    }

    public Config withSections(List<GuideSectionMeta> sections) {
        Utils.checkNotNull(sections, "sections");
        this.sections = sections;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config other = (Config)o;
        return Utils.enhancedDeepEquals(this.warning, other.warning) && Utils.enhancedDeepEquals(this.sections, other.sections);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.warning, this.sections);
    }

    public String toString() {
        return Utils.toString(Config.class, "warning", this.warning, "sections", this.sections);
    }

    public static final class Builder {
        private JsonNullable<String> warning = JsonNullable.undefined();
        private List<GuideSectionMeta> sections;

        private Builder() {
        }

        public Builder warning(String warning) {
            Utils.checkNotNull(warning, "warning");
            this.warning = JsonNullable.of((Object)warning);
            return this;
        }

        public Builder warning(JsonNullable<String> warning) {
            Utils.checkNotNull(warning, "warning");
            this.warning = warning;
            return this;
        }

        public Builder sections(List<GuideSectionMeta> sections) {
            Utils.checkNotNull(sections, "sections");
            this.sections = sections;
            return this;
        }

        public Config build() {
            return new Config(this.warning, this.sections);
        }
    }
}

