/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateAnswerValue {
    public static final CreateAnswerValue SHORT_TEXT = new CreateAnswerValue("short_text");
    public static final CreateAnswerValue LONG_TEXT = new CreateAnswerValue("long_text");
    public static final CreateAnswerValue ATTACHMENT = new CreateAnswerValue("attachment");
    public static final CreateAnswerValue MULTI_SELECT = new CreateAnswerValue("multi_select");
    public static final CreateAnswerValue SINGLE_SELECT = new CreateAnswerValue("single_select");
    public static final CreateAnswerValue BOOLEAN = new CreateAnswerValue("boolean");
    public static final CreateAnswerValue NUMBER = new CreateAnswerValue("number");
    public static final CreateAnswerValue DATE = new CreateAnswerValue("date");
    public static final CreateAnswerValue VIDEO = new CreateAnswerValue("video");
    public static final CreateAnswerValue REFERENCE_CHECK = new CreateAnswerValue("reference_check");
    public static final CreateAnswerValue URL = new CreateAnswerValue("url");
    public static final CreateAnswerValue UNMAPPED_VALUE = new CreateAnswerValue("unmapped_value");
    private static final Map<String, CreateAnswerValue> values = CreateAnswerValue.createValuesMap();
    private static final Map<String, CreateAnswerValueEnum> enums = CreateAnswerValue.createEnumsMap();
    private final String value;

    private CreateAnswerValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static CreateAnswerValue of(String value) {
        Class<CreateAnswerValue> clazz = CreateAnswerValue.class;
        synchronized (CreateAnswerValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new CreateAnswerValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<CreateAnswerValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateAnswerValue other = (CreateAnswerValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "CreateAnswerValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CreateAnswerValue[] values() {
        Class<CreateAnswerValue> clazz = CreateAnswerValue.class;
        synchronized (CreateAnswerValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new CreateAnswerValue[0]);
        }
    }

    private static final Map<String, CreateAnswerValue> createValuesMap() {
        LinkedHashMap<String, CreateAnswerValue> map = new LinkedHashMap<String, CreateAnswerValue>();
        map.put("short_text", SHORT_TEXT);
        map.put("long_text", LONG_TEXT);
        map.put("attachment", ATTACHMENT);
        map.put("multi_select", MULTI_SELECT);
        map.put("single_select", SINGLE_SELECT);
        map.put("boolean", BOOLEAN);
        map.put("number", NUMBER);
        map.put("date", DATE);
        map.put("video", VIDEO);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("url", URL);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CreateAnswerValueEnum> createEnumsMap() {
        HashMap<String, CreateAnswerValueEnum> map = new HashMap<String, CreateAnswerValueEnum>();
        map.put("short_text", CreateAnswerValueEnum.SHORT_TEXT);
        map.put("long_text", CreateAnswerValueEnum.LONG_TEXT);
        map.put("attachment", CreateAnswerValueEnum.ATTACHMENT);
        map.put("multi_select", CreateAnswerValueEnum.MULTI_SELECT);
        map.put("single_select", CreateAnswerValueEnum.SINGLE_SELECT);
        map.put("boolean", CreateAnswerValueEnum.BOOLEAN);
        map.put("number", CreateAnswerValueEnum.NUMBER);
        map.put("date", CreateAnswerValueEnum.DATE);
        map.put("video", CreateAnswerValueEnum.VIDEO);
        map.put("reference_check", CreateAnswerValueEnum.REFERENCE_CHECK);
        map.put("url", CreateAnswerValueEnum.URL);
        map.put("unmapped_value", CreateAnswerValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum CreateAnswerValueEnum {
        SHORT_TEXT("short_text"),
        LONG_TEXT("long_text"),
        ATTACHMENT("attachment"),
        MULTI_SELECT("multi_select"),
        SINGLE_SELECT("single_select"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        DATE("date"),
        VIDEO("video"),
        REFERENCE_CHECK("reference_check"),
        URL("url"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private CreateAnswerValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

