/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EmployeeValue {
    public static final EmployeeValue MALE = new EmployeeValue("male");
    public static final EmployeeValue FEMALE = new EmployeeValue("female");
    public static final EmployeeValue NON_BINARY = new EmployeeValue("non_binary");
    public static final EmployeeValue OTHER = new EmployeeValue("other");
    public static final EmployeeValue NOT_DISCLOSED = new EmployeeValue("not_disclosed");
    public static final EmployeeValue DIVERSE = new EmployeeValue("diverse");
    public static final EmployeeValue UNMAPPED_VALUE = new EmployeeValue("unmapped_value");
    private static final Map<String, EmployeeValue> values = EmployeeValue.createValuesMap();
    private static final Map<String, EmployeeValueEnum> enums = EmployeeValue.createEnumsMap();
    private final String value;

    private EmployeeValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static EmployeeValue of(String value) {
        Class<EmployeeValue> clazz = EmployeeValue.class;
        synchronized (EmployeeValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmployeeValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<EmployeeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmployeeValue other = (EmployeeValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmployeeValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmployeeValue[] values() {
        Class<EmployeeValue> clazz = EmployeeValue.class;
        synchronized (EmployeeValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmployeeValue[0]);
        }
    }

    private static final Map<String, EmployeeValue> createValuesMap() {
        LinkedHashMap<String, EmployeeValue> map = new LinkedHashMap<String, EmployeeValue>();
        map.put("male", MALE);
        map.put("female", FEMALE);
        map.put("non_binary", NON_BINARY);
        map.put("other", OTHER);
        map.put("not_disclosed", NOT_DISCLOSED);
        map.put("diverse", DIVERSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EmployeeValueEnum> createEnumsMap() {
        HashMap<String, EmployeeValueEnum> map = new HashMap<String, EmployeeValueEnum>();
        map.put("male", EmployeeValueEnum.MALE);
        map.put("female", EmployeeValueEnum.FEMALE);
        map.put("non_binary", EmployeeValueEnum.NON_BINARY);
        map.put("other", EmployeeValueEnum.OTHER);
        map.put("not_disclosed", EmployeeValueEnum.NOT_DISCLOSED);
        map.put("diverse", EmployeeValueEnum.DIVERSE);
        map.put("unmapped_value", EmployeeValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum EmployeeValueEnum {
        MALE("male"),
        FEMALE("female"),
        NON_BINARY("non_binary"),
        OTHER("other"),
        NOT_DISCLOSED("not_disclosed"),
        DIVERSE("diverse"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private EmployeeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

