/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EmploymentValue {
    public static final EmploymentValue HOUR = new EmploymentValue("hour");
    public static final EmploymentValue DAY = new EmploymentValue("day");
    public static final EmploymentValue WEEK = new EmploymentValue("week");
    public static final EmploymentValue EVERY_TWO_WEEKS = new EmploymentValue("every_two_weeks");
    public static final EmploymentValue MONTH = new EmploymentValue("month");
    public static final EmploymentValue TWICE_A_MONTH = new EmploymentValue("twice_a_month");
    public static final EmploymentValue EVERY_TWO_MONTHS = new EmploymentValue("every_two_months");
    public static final EmploymentValue QUARTER = new EmploymentValue("quarter");
    public static final EmploymentValue EVERY_SIX_MONTHS = new EmploymentValue("every_six_months");
    public static final EmploymentValue YEAR = new EmploymentValue("year");
    public static final EmploymentValue ONE_OFF = new EmploymentValue("one_off");
    public static final EmploymentValue NONE = new EmploymentValue("none");
    public static final EmploymentValue UNMAPPED_VALUE = new EmploymentValue("unmapped_value");
    private static final Map<String, EmploymentValue> values = EmploymentValue.createValuesMap();
    private static final Map<String, EmploymentValueEnum> enums = EmploymentValue.createEnumsMap();
    private final String value;

    private EmploymentValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static EmploymentValue of(String value) {
        Class<EmploymentValue> clazz = EmploymentValue.class;
        synchronized (EmploymentValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmploymentValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<EmploymentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmploymentValue other = (EmploymentValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmploymentValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentValue[] values() {
        Class<EmploymentValue> clazz = EmploymentValue.class;
        synchronized (EmploymentValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmploymentValue[0]);
        }
    }

    private static final Map<String, EmploymentValue> createValuesMap() {
        LinkedHashMap<String, EmploymentValue> map = new LinkedHashMap<String, EmploymentValue>();
        map.put("hour", HOUR);
        map.put("day", DAY);
        map.put("week", WEEK);
        map.put("every_two_weeks", EVERY_TWO_WEEKS);
        map.put("month", MONTH);
        map.put("twice_a_month", TWICE_A_MONTH);
        map.put("every_two_months", EVERY_TWO_MONTHS);
        map.put("quarter", QUARTER);
        map.put("every_six_months", EVERY_SIX_MONTHS);
        map.put("year", YEAR);
        map.put("one_off", ONE_OFF);
        map.put("none", NONE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EmploymentValueEnum> createEnumsMap() {
        HashMap<String, EmploymentValueEnum> map = new HashMap<String, EmploymentValueEnum>();
        map.put("hour", EmploymentValueEnum.HOUR);
        map.put("day", EmploymentValueEnum.DAY);
        map.put("week", EmploymentValueEnum.WEEK);
        map.put("every_two_weeks", EmploymentValueEnum.EVERY_TWO_WEEKS);
        map.put("month", EmploymentValueEnum.MONTH);
        map.put("twice_a_month", EmploymentValueEnum.TWICE_A_MONTH);
        map.put("every_two_months", EmploymentValueEnum.EVERY_TWO_MONTHS);
        map.put("quarter", EmploymentValueEnum.QUARTER);
        map.put("every_six_months", EmploymentValueEnum.EVERY_SIX_MONTHS);
        map.put("year", EmploymentValueEnum.YEAR);
        map.put("one_off", EmploymentValueEnum.ONE_OFF);
        map.put("none", EmploymentValueEnum.NONE);
        map.put("unmapped_value", EmploymentValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum EmploymentValueEnum {
        HOUR("hour"),
        DAY("day"),
        WEEK("week"),
        EVERY_TWO_WEEKS("every_two_weeks"),
        MONTH("month"),
        TWICE_A_MONTH("twice_a_month"),
        EVERY_TWO_MONTHS("every_two_months"),
        QUARTER("quarter"),
        EVERY_SIX_MONTHS("every_six_months"),
        YEAR("year"),
        ONE_OFF("one_off"),
        NONE("none"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private EmploymentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

