/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.GuideStepMeta;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class GuideSectionMeta {
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="content")
    private String content;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="list")
    private JsonNullable<? extends List<String>> list;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="steps")
    private JsonNullable<? extends List<GuideStepMeta>> steps;

    @JsonCreator
    public GuideSectionMeta(@JsonProperty(value="title") String title, @JsonProperty(value="content") String content, @JsonProperty(value="list") JsonNullable<? extends List<String>> list, @JsonProperty(value="steps") JsonNullable<? extends List<GuideStepMeta>> steps) {
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(list, "list");
        Utils.checkNotNull(steps, "steps");
        this.title = title;
        this.content = content;
        this.list = list;
        this.steps = steps;
    }

    public GuideSectionMeta(String title, String content) {
        this(title, content, (JsonNullable<? extends List<String>>)JsonNullable.undefined(), (JsonNullable<? extends List<GuideStepMeta>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String title() {
        return this.title;
    }

    @JsonIgnore
    public String content() {
        return this.content;
    }

    @JsonIgnore
    public JsonNullable<List<String>> list() {
        return this.list;
    }

    @JsonIgnore
    public JsonNullable<List<GuideStepMeta>> steps() {
        return this.steps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GuideSectionMeta withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    public GuideSectionMeta withContent(String content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    public GuideSectionMeta withList(List<String> list) {
        Utils.checkNotNull(list, "list");
        this.list = JsonNullable.of(list);
        return this;
    }

    public GuideSectionMeta withList(JsonNullable<? extends List<String>> list) {
        Utils.checkNotNull(list, "list");
        this.list = list;
        return this;
    }

    public GuideSectionMeta withSteps(List<GuideStepMeta> steps) {
        Utils.checkNotNull(steps, "steps");
        this.steps = JsonNullable.of(steps);
        return this;
    }

    public GuideSectionMeta withSteps(JsonNullable<? extends List<GuideStepMeta>> steps) {
        Utils.checkNotNull(steps, "steps");
        this.steps = steps;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuideSectionMeta other = (GuideSectionMeta)o;
        return Utils.enhancedDeepEquals(this.title, other.title) && Utils.enhancedDeepEquals(this.content, other.content) && Utils.enhancedDeepEquals(this.list, other.list) && Utils.enhancedDeepEquals(this.steps, other.steps);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.title, this.content, this.list, this.steps);
    }

    public String toString() {
        return Utils.toString(GuideSectionMeta.class, "title", this.title, "content", this.content, "list", this.list, "steps", this.steps);
    }

    public static final class Builder {
        private String title;
        private String content;
        private JsonNullable<? extends List<String>> list = JsonNullable.undefined();
        private JsonNullable<? extends List<GuideStepMeta>> steps = JsonNullable.undefined();

        private Builder() {
        }

        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }

        public Builder content(String content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }

        public Builder list(List<String> list) {
            Utils.checkNotNull(list, "list");
            this.list = JsonNullable.of(list);
            return this;
        }

        public Builder list(JsonNullable<? extends List<String>> list) {
            Utils.checkNotNull(list, "list");
            this.list = list;
            return this;
        }

        public Builder steps(List<GuideStepMeta> steps) {
            Utils.checkNotNull(steps, "steps");
            this.steps = JsonNullable.of(steps);
            return this;
        }

        public Builder steps(JsonNullable<? extends List<GuideStepMeta>> steps) {
            Utils.checkNotNull(steps, "steps");
            this.steps = steps;
            return this;
        }

        public GuideSectionMeta build() {
            return new GuideSectionMeta(this.title, this.content, this.list, this.steps);
        }
    }
}

