/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HRISTeamValue {
    public static final HRISTeamValue TEAM = new HRISTeamValue("team");
    public static final HRISTeamValue UNMAPPED_VALUE = new HRISTeamValue("unmapped_value");
    private static final Map<String, HRISTeamValue> values = HRISTeamValue.createValuesMap();
    private static final Map<String, HRISTeamValueEnum> enums = HRISTeamValue.createEnumsMap();
    private final String value;

    private HRISTeamValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static HRISTeamValue of(String value) {
        Class<HRISTeamValue> clazz = HRISTeamValue.class;
        synchronized (HRISTeamValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HRISTeamValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<HRISTeamValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HRISTeamValue other = (HRISTeamValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HRISTeamValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISTeamValue[] values() {
        Class<HRISTeamValue> clazz = HRISTeamValue.class;
        synchronized (HRISTeamValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HRISTeamValue[0]);
        }
    }

    private static final Map<String, HRISTeamValue> createValuesMap() {
        LinkedHashMap<String, HRISTeamValue> map = new LinkedHashMap<String, HRISTeamValue>();
        map.put("team", TEAM);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HRISTeamValueEnum> createEnumsMap() {
        HashMap<String, HRISTeamValueEnum> map = new HashMap<String, HRISTeamValueEnum>();
        map.put("team", HRISTeamValueEnum.TEAM);
        map.put("unmapped_value", HRISTeamValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum HRISTeamValueEnum {
        TEAM("team"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private HRISTeamValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

