/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TicketingReadTicketValue {
    public static final TicketingReadTicketValue LOWEST = new TicketingReadTicketValue("lowest");
    public static final TicketingReadTicketValue LOW = new TicketingReadTicketValue("low");
    public static final TicketingReadTicketValue MEDIUM = new TicketingReadTicketValue("medium");
    public static final TicketingReadTicketValue HIGH = new TicketingReadTicketValue("high");
    public static final TicketingReadTicketValue HIGHEST = new TicketingReadTicketValue("highest");
    public static final TicketingReadTicketValue UNMAPPED_VALUE = new TicketingReadTicketValue("unmapped_value");
    private static final Map<String, TicketingReadTicketValue> values = TicketingReadTicketValue.createValuesMap();
    private static final Map<String, TicketingReadTicketValueEnum> enums = TicketingReadTicketValue.createEnumsMap();
    private final String value;

    private TicketingReadTicketValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static TicketingReadTicketValue of(String value) {
        Class<TicketingReadTicketValue> clazz = TicketingReadTicketValue.class;
        synchronized (TicketingReadTicketValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TicketingReadTicketValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<TicketingReadTicketValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketingReadTicketValue other = (TicketingReadTicketValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TicketingReadTicketValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TicketingReadTicketValue[] values() {
        Class<TicketingReadTicketValue> clazz = TicketingReadTicketValue.class;
        synchronized (TicketingReadTicketValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TicketingReadTicketValue[0]);
        }
    }

    private static final Map<String, TicketingReadTicketValue> createValuesMap() {
        LinkedHashMap<String, TicketingReadTicketValue> map = new LinkedHashMap<String, TicketingReadTicketValue>();
        map.put("lowest", LOWEST);
        map.put("low", LOW);
        map.put("medium", MEDIUM);
        map.put("high", HIGH);
        map.put("highest", HIGHEST);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TicketingReadTicketValueEnum> createEnumsMap() {
        HashMap<String, TicketingReadTicketValueEnum> map = new HashMap<String, TicketingReadTicketValueEnum>();
        map.put("lowest", TicketingReadTicketValueEnum.LOWEST);
        map.put("low", TicketingReadTicketValueEnum.LOW);
        map.put("medium", TicketingReadTicketValueEnum.MEDIUM);
        map.put("high", TicketingReadTicketValueEnum.HIGH);
        map.put("highest", TicketingReadTicketValueEnum.HIGHEST);
        map.put("unmapped_value", TicketingReadTicketValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TicketingReadTicketValueEnum {
        LOWEST("lowest"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high"),
        HIGHEST("highest"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TicketingReadTicketValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

