/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TicketingUserValue {
    public static final TicketingUserValue AGENT = new TicketingUserValue("agent");
    public static final TicketingUserValue CONTACT = new TicketingUserValue("contact");
    public static final TicketingUserValue BOT = new TicketingUserValue("bot");
    public static final TicketingUserValue UNMAPPED_VALUE = new TicketingUserValue("unmapped_value");
    private static final Map<String, TicketingUserValue> values = TicketingUserValue.createValuesMap();
    private static final Map<String, TicketingUserValueEnum> enums = TicketingUserValue.createEnumsMap();
    private final String value;

    private TicketingUserValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static TicketingUserValue of(String value) {
        Class<TicketingUserValue> clazz = TicketingUserValue.class;
        synchronized (TicketingUserValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TicketingUserValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<TicketingUserValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketingUserValue other = (TicketingUserValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TicketingUserValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TicketingUserValue[] values() {
        Class<TicketingUserValue> clazz = TicketingUserValue.class;
        synchronized (TicketingUserValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TicketingUserValue[0]);
        }
    }

    private static final Map<String, TicketingUserValue> createValuesMap() {
        LinkedHashMap<String, TicketingUserValue> map = new LinkedHashMap<String, TicketingUserValue>();
        map.put("agent", AGENT);
        map.put("contact", CONTACT);
        map.put("bot", BOT);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TicketingUserValueEnum> createEnumsMap() {
        HashMap<String, TicketingUserValueEnum> map = new HashMap<String, TicketingUserValueEnum>();
        map.put("agent", TicketingUserValueEnum.AGENT);
        map.put("contact", TicketingUserValueEnum.CONTACT);
        map.put("bot", TicketingUserValueEnum.BOT);
        map.put("unmapped_value", TicketingUserValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TicketingUserValueEnum {
        AGENT("agent"),
        CONTACT("contact"),
        BOT("bot"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TicketingUserValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

