/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.models.components.ProviderError;
import com.stackone.stackone_client_java.models.errors.AsyncSDKError;
import com.stackone.stackone_client_java.models.errors.StackOneError;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.openapitools.jackson.nullable.JsonNullable;

public class BadRequestResponse
extends StackOneError {
    @Nullable
    private final Data data;
    @Nullable
    private final Throwable deserializationException;

    public BadRequestResponse(int code, byte[] body, HttpResponse<?> rawResponse, @Nullable Data data, @Nullable Throwable deserializationException) {
        super("API error occurred", code, body, rawResponse, null);
        this.data = data;
        this.deserializationException = deserializationException;
    }

    public static BadRequestResponse from(HttpResponse<InputStream> response) {
        try {
            byte[] bytes = Utils.extractByteArrayFromBody(response);
            Data data = (Data)Utils.mapper().readValue(bytes, Data.class);
            return new BadRequestResponse(response.statusCode(), bytes, response, data, null);
        }
        catch (Exception e) {
            return new BadRequestResponse(response.statusCode(), null, response, null, (Throwable)e);
        }
    }

    public static CompletableFuture<BadRequestResponse> fromAsync(HttpResponse<Blob> response) {
        return response.body().toByteArray().handle((bytes, err) -> {
            if (err != null) {
                throw new AsyncSDKError("Error reading response body: " + err.getMessage(), response.statusCode(), null, response, (Throwable)err);
            }
            try {
                return new BadRequestResponse(response.statusCode(), (byte[])bytes, response, (Data)Utils.mapper().readValue(bytes, (TypeReference)new TypeReference<Data>(){}), null);
            }
            catch (Exception e) {
                return new BadRequestResponse(response.statusCode(), (byte[])bytes, response, null, (Throwable)e);
            }
        });
    }

    @Deprecated
    public Optional<Double> statusCode() {
        return this.data().map(Data::statusCode);
    }

    @Deprecated
    public Optional<OffsetDateTime> timestamp() {
        return this.data().map(Data::timestamp);
    }

    @Deprecated
    public Optional<JsonNullable<List<ProviderError>>> providerErrors() {
        return this.data().map(Data::providerErrors);
    }

    public Optional<Data> data() {
        return Optional.ofNullable(this.data);
    }

    public Optional<Throwable> deserializationException() {
        return Optional.ofNullable(this.deserializationException);
    }

    public static class Data {
        @JsonProperty(value="statusCode")
        private double statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="timestamp")
        private OffsetDateTime timestamp;
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="data")
        private JsonNullable<? extends Data> data;
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="provider_errors")
        private JsonNullable<? extends List<ProviderError>> providerErrors;

        @JsonCreator
        public Data(@JsonProperty(value="statusCode") double statusCode, @JsonProperty(value="message") String message, @JsonProperty(value="timestamp") OffsetDateTime timestamp, @JsonProperty(value="data") JsonNullable<? extends Data> data, @JsonProperty(value="provider_errors") JsonNullable<? extends List<ProviderError>> providerErrors) {
            Utils.checkNotNull(statusCode, "statusCode");
            Utils.checkNotNull(message, "message");
            Utils.checkNotNull(timestamp, "timestamp");
            Utils.checkNotNull(data, "data");
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.statusCode = statusCode;
            this.message = message;
            this.timestamp = timestamp;
            this.data = data;
            this.providerErrors = providerErrors;
        }

        public Data(double statusCode, String message, OffsetDateTime timestamp) {
            this(statusCode, message, timestamp, (JsonNullable<? extends Data>)JsonNullable.undefined(), (JsonNullable<? extends List<ProviderError>>)JsonNullable.undefined());
        }

        @JsonIgnore
        public double statusCode() {
            return this.statusCode;
        }

        @JsonIgnore
        public String message() {
            return this.message;
        }

        @JsonIgnore
        public OffsetDateTime timestamp() {
            return this.timestamp;
        }

        @JsonIgnore
        public JsonNullable<Data> data() {
            return this.data;
        }

        @JsonIgnore
        public JsonNullable<List<ProviderError>> providerErrors() {
            return this.providerErrors;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Data withStatusCode(double statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Data withMessage(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Data withTimestamp(OffsetDateTime timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }

        public Data withData(Data data) {
            Utils.checkNotNull(data, "data");
            this.data = JsonNullable.of((Object)data);
            return this;
        }

        public Data withData(JsonNullable<? extends Data> data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Data withProviderErrors(List<ProviderError> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = JsonNullable.of(providerErrors);
            return this;
        }

        public Data withProviderErrors(JsonNullable<? extends List<ProviderError>> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = providerErrors;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data other = (Data)o;
            return Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.message, other.message) && Utils.enhancedDeepEquals(this.timestamp, other.timestamp) && Utils.enhancedDeepEquals(this.data, other.data) && Utils.enhancedDeepEquals(this.providerErrors, other.providerErrors);
        }

        public int hashCode() {
            return Utils.enhancedHash(this.statusCode, this.message, this.timestamp, this.data, this.providerErrors);
        }

        public String toString() {
            return Utils.toString(Data.class, "statusCode", this.statusCode, "message", this.message, "timestamp", this.timestamp, "data", this.data, "providerErrors", this.providerErrors);
        }

        public static final class Builder {
            private Double statusCode;
            private String message;
            private OffsetDateTime timestamp;
            private JsonNullable<? extends Data> data = JsonNullable.undefined();
            private JsonNullable<? extends List<ProviderError>> providerErrors = JsonNullable.undefined();

            private Builder() {
            }

            public Builder statusCode(double statusCode) {
                Utils.checkNotNull(statusCode, "statusCode");
                this.statusCode = statusCode;
                return this;
            }

            public Builder message(String message) {
                Utils.checkNotNull(message, "message");
                this.message = message;
                return this;
            }

            public Builder timestamp(OffsetDateTime timestamp) {
                Utils.checkNotNull(timestamp, "timestamp");
                this.timestamp = timestamp;
                return this;
            }

            public Builder data(Data data) {
                Utils.checkNotNull(data, "data");
                this.data = JsonNullable.of((Object)data);
                return this;
            }

            public Builder data(JsonNullable<? extends Data> data) {
                Utils.checkNotNull(data, "data");
                this.data = data;
                return this;
            }

            public Builder providerErrors(List<ProviderError> providerErrors) {
                Utils.checkNotNull(providerErrors, "providerErrors");
                this.providerErrors = JsonNullable.of(providerErrors);
                return this;
            }

            public Builder providerErrors(JsonNullable<? extends List<ProviderError>> providerErrors) {
                Utils.checkNotNull(providerErrors, "providerErrors");
                this.providerErrors = providerErrors;
                return this;
            }

            public Data build() {
                return new Data(this.statusCode, this.message, this.timestamp, this.data, this.providerErrors);
            }
        }
    }
}

