/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingTaxRateResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AccountingGetCompanyTaxRateResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AccountingTaxRateResult> accountingTaxRateResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AccountingGetCompanyTaxRateResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AccountingTaxRateResult> accountingTaxRateResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountingTaxRateResult, "accountingTaxRateResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountingTaxRateResult = accountingTaxRateResult;
        this.headers = headers;
    }

    public AccountingGetCompanyTaxRateResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountingTaxRateResult> accountingTaxRateResult() {
        return this.accountingTaxRateResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingGetCompanyTaxRateResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AccountingGetCompanyTaxRateResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AccountingGetCompanyTaxRateResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AccountingGetCompanyTaxRateResponse withAccountingTaxRateResult(AccountingTaxRateResult accountingTaxRateResult) {
        Utils.checkNotNull(accountingTaxRateResult, "accountingTaxRateResult");
        this.accountingTaxRateResult = Optional.ofNullable(accountingTaxRateResult);
        return this;
    }

    public AccountingGetCompanyTaxRateResponse withAccountingTaxRateResult(Optional<? extends AccountingTaxRateResult> accountingTaxRateResult) {
        Utils.checkNotNull(accountingTaxRateResult, "accountingTaxRateResult");
        this.accountingTaxRateResult = accountingTaxRateResult;
        return this;
    }

    public AccountingGetCompanyTaxRateResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingGetCompanyTaxRateResponse other = (AccountingGetCompanyTaxRateResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.accountingTaxRateResult, other.accountingTaxRateResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.accountingTaxRateResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AccountingGetCompanyTaxRateResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountingTaxRateResult", this.accountingTaxRateResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AccountingTaxRateResult> accountingTaxRateResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountingTaxRateResult(AccountingTaxRateResult accountingTaxRateResult) {
            Utils.checkNotNull(accountingTaxRateResult, "accountingTaxRateResult");
            this.accountingTaxRateResult = Optional.ofNullable(accountingTaxRateResult);
            return this;
        }

        public Builder accountingTaxRateResult(Optional<? extends AccountingTaxRateResult> accountingTaxRateResult) {
            Utils.checkNotNull(accountingTaxRateResult, "accountingTaxRateResult");
            this.accountingTaxRateResult = accountingTaxRateResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AccountingGetCompanyTaxRateResponse build() {
            return new AccountingGetCompanyTaxRateResponse(this.contentType, this.statusCode, this.rawResponse, this.accountingTaxRateResult, this.headers);
        }
    }
}

