/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AccountingListCompanyTaxRatesRequest;
import com.stackone.stackone_client_java.models.operations.AccountingListCompanyTaxRatesResponse;
import com.stackone.stackone_client_java.operations.AccountingListCompanyTaxRates;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class AccountingListCompanyTaxRatesRequestBuilder {
    private AccountingListCompanyTaxRatesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AccountingListCompanyTaxRatesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AccountingListCompanyTaxRatesRequestBuilder request(AccountingListCompanyTaxRatesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AccountingListCompanyTaxRatesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AccountingListCompanyTaxRatesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AccountingListCompanyTaxRatesResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AccountingListCompanyTaxRates.Sync operation = new AccountingListCompanyTaxRates.Sync(this.sdkConfiguration, options, this._headers);
        return (AccountingListCompanyTaxRatesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<AccountingListCompanyTaxRatesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AccountingListCompanyTaxRates.Sync operation = new AccountingListCompanyTaxRates.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<AccountingListCompanyTaxRatesRequest, String> iterator = new Paginator<AccountingListCompanyTaxRatesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), AccountingListCompanyTaxRatesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<AccountingListCompanyTaxRatesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

