/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateApplicationRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsCreateApplicationRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsCreateApplicationRequestDto atsCreateApplicationRequestDto;

    @JsonCreator
    public AtsCreateApplicationRequest(String xAccountId, Optional<String> prefer, AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateApplicationRequestDto, "atsCreateApplicationRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateApplicationRequestDto = atsCreateApplicationRequestDto;
    }

    public AtsCreateApplicationRequest(String xAccountId, AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateApplicationRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AtsCreateApplicationRequestDto atsCreateApplicationRequestDto() {
        return this.atsCreateApplicationRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsCreateApplicationRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateApplicationRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsCreateApplicationRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateApplicationRequest withAtsCreateApplicationRequestDto(AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
        Utils.checkNotNull(atsCreateApplicationRequestDto, "atsCreateApplicationRequestDto");
        this.atsCreateApplicationRequestDto = atsCreateApplicationRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsCreateApplicationRequest other = (AtsCreateApplicationRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.atsCreateApplicationRequestDto, other.atsCreateApplicationRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.atsCreateApplicationRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsCreateApplicationRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "atsCreateApplicationRequestDto", this.atsCreateApplicationRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private AtsCreateApplicationRequestDto atsCreateApplicationRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder atsCreateApplicationRequestDto(AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
            Utils.checkNotNull(atsCreateApplicationRequestDto, "atsCreateApplicationRequestDto");
            this.atsCreateApplicationRequestDto = atsCreateApplicationRequestDto;
            return this;
        }

        public AtsCreateApplicationRequest build() {
            return new AtsCreateApplicationRequest(this.xAccountId, this.prefer, this.atsCreateApplicationRequestDto);
        }
    }
}

