/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateBackgroundCheckPackagesRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsCreateBackgroundCheckPackageRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto;

    @JsonCreator
    public AtsCreateBackgroundCheckPackageRequest(String xAccountId, Optional<String> prefer, AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateBackgroundCheckPackagesRequestDto, "atsCreateBackgroundCheckPackagesRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateBackgroundCheckPackagesRequestDto = atsCreateBackgroundCheckPackagesRequestDto;
    }

    public AtsCreateBackgroundCheckPackageRequest(String xAccountId, AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateBackgroundCheckPackagesRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto() {
        return this.atsCreateBackgroundCheckPackagesRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsCreateBackgroundCheckPackageRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateBackgroundCheckPackageRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsCreateBackgroundCheckPackageRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateBackgroundCheckPackageRequest withAtsCreateBackgroundCheckPackagesRequestDto(AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto) {
        Utils.checkNotNull(atsCreateBackgroundCheckPackagesRequestDto, "atsCreateBackgroundCheckPackagesRequestDto");
        this.atsCreateBackgroundCheckPackagesRequestDto = atsCreateBackgroundCheckPackagesRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsCreateBackgroundCheckPackageRequest other = (AtsCreateBackgroundCheckPackageRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.atsCreateBackgroundCheckPackagesRequestDto, other.atsCreateBackgroundCheckPackagesRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.atsCreateBackgroundCheckPackagesRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsCreateBackgroundCheckPackageRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "atsCreateBackgroundCheckPackagesRequestDto", this.atsCreateBackgroundCheckPackagesRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder atsCreateBackgroundCheckPackagesRequestDto(AtsCreateBackgroundCheckPackagesRequestDto atsCreateBackgroundCheckPackagesRequestDto) {
            Utils.checkNotNull(atsCreateBackgroundCheckPackagesRequestDto, "atsCreateBackgroundCheckPackagesRequestDto");
            this.atsCreateBackgroundCheckPackagesRequestDto = atsCreateBackgroundCheckPackagesRequestDto;
            return this;
        }

        public AtsCreateBackgroundCheckPackageRequest build() {
            return new AtsCreateBackgroundCheckPackageRequest(this.xAccountId, this.prefer, this.atsCreateBackgroundCheckPackagesRequestDto);
        }
    }
}

