/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateOfferRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsCreateOfferRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsCreateOfferRequestDto atsCreateOfferRequestDto;

    @JsonCreator
    public AtsCreateOfferRequest(String xAccountId, Optional<String> prefer, AtsCreateOfferRequestDto atsCreateOfferRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateOfferRequestDto, "atsCreateOfferRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateOfferRequestDto = atsCreateOfferRequestDto;
    }

    public AtsCreateOfferRequest(String xAccountId, AtsCreateOfferRequestDto atsCreateOfferRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateOfferRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AtsCreateOfferRequestDto atsCreateOfferRequestDto() {
        return this.atsCreateOfferRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsCreateOfferRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateOfferRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsCreateOfferRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateOfferRequest withAtsCreateOfferRequestDto(AtsCreateOfferRequestDto atsCreateOfferRequestDto) {
        Utils.checkNotNull(atsCreateOfferRequestDto, "atsCreateOfferRequestDto");
        this.atsCreateOfferRequestDto = atsCreateOfferRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsCreateOfferRequest other = (AtsCreateOfferRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.atsCreateOfferRequestDto, other.atsCreateOfferRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.atsCreateOfferRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsCreateOfferRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "atsCreateOfferRequestDto", this.atsCreateOfferRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private AtsCreateOfferRequestDto atsCreateOfferRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder atsCreateOfferRequestDto(AtsCreateOfferRequestDto atsCreateOfferRequestDto) {
            Utils.checkNotNull(atsCreateOfferRequestDto, "atsCreateOfferRequestDto");
            this.atsCreateOfferRequestDto = atsCreateOfferRequestDto;
            return this;
        }

        public AtsCreateOfferRequest build() {
            return new AtsCreateOfferRequest(this.xAccountId, this.prefer, this.atsCreateOfferRequestDto);
        }
    }
}

