/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class DocumentsGetFileRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-stackone-api-session-token")
    private Optional<String> xStackoneApiSessionToken;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=raw")
    private JsonNullable<Boolean> raw;
    @SpeakeasyMetadata(value="queryParam:style=deepObject,explode=true,name=proxy")
    private JsonNullable<? extends Map<String, Object>> proxy;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=fields")
    private JsonNullable<String> fields;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=include")
    private JsonNullable<String> include;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;

    @JsonCreator
    public DocumentsGetFileRequest(String xAccountId, Optional<String> xStackoneApiSessionToken, String id, JsonNullable<Boolean> raw, JsonNullable<? extends Map<String, Object>> proxy, JsonNullable<String> fields, JsonNullable<String> include, Optional<String> prefer) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(raw, "raw");
        Utils.checkNotNull(proxy, "proxy");
        Utils.checkNotNull(fields, "fields");
        Utils.checkNotNull(include, "include");
        Utils.checkNotNull(prefer, "prefer");
        this.xAccountId = xAccountId;
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        this.id = id;
        this.raw = raw;
        this.proxy = proxy;
        this.fields = fields;
        this.include = include;
        this.prefer = prefer;
    }

    public DocumentsGetFileRequest(String xAccountId, String id) {
        this(xAccountId, Optional.empty(), id, (JsonNullable<Boolean>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty());
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> xStackoneApiSessionToken() {
        return this.xStackoneApiSessionToken;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<Boolean> raw() {
        return this.raw;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> proxy() {
        return this.proxy;
    }

    @JsonIgnore
    public JsonNullable<String> fields() {
        return this.fields;
    }

    @JsonIgnore
    public JsonNullable<String> include() {
        return this.include;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DocumentsGetFileRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public DocumentsGetFileRequest withXStackoneApiSessionToken(String xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
        return this;
    }

    public DocumentsGetFileRequest withXStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        return this;
    }

    public DocumentsGetFileRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public DocumentsGetFileRequest withRaw(boolean raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of((Object)raw);
        return this;
    }

    public DocumentsGetFileRequest withRaw(JsonNullable<Boolean> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    public DocumentsGetFileRequest withProxy(Map<String, Object> proxy) {
        Utils.checkNotNull(proxy, "proxy");
        this.proxy = JsonNullable.of(proxy);
        return this;
    }

    public DocumentsGetFileRequest withProxy(JsonNullable<? extends Map<String, Object>> proxy) {
        Utils.checkNotNull(proxy, "proxy");
        this.proxy = proxy;
        return this;
    }

    public DocumentsGetFileRequest withFields(String fields) {
        Utils.checkNotNull(fields, "fields");
        this.fields = JsonNullable.of((Object)fields);
        return this;
    }

    public DocumentsGetFileRequest withFields(JsonNullable<String> fields) {
        Utils.checkNotNull(fields, "fields");
        this.fields = fields;
        return this;
    }

    public DocumentsGetFileRequest withInclude(String include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of((Object)include);
        return this;
    }

    public DocumentsGetFileRequest withInclude(JsonNullable<String> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    public DocumentsGetFileRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public DocumentsGetFileRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentsGetFileRequest other = (DocumentsGetFileRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.xStackoneApiSessionToken, other.xStackoneApiSessionToken) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.raw, other.raw) && Utils.enhancedDeepEquals(this.proxy, other.proxy) && Utils.enhancedDeepEquals(this.fields, other.fields) && Utils.enhancedDeepEquals(this.include, other.include) && Utils.enhancedDeepEquals(this.prefer, other.prefer);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.xStackoneApiSessionToken, this.id, this.raw, this.proxy, this.fields, this.include, this.prefer);
    }

    public String toString() {
        return Utils.toString(DocumentsGetFileRequest.class, "xAccountId", this.xAccountId, "xStackoneApiSessionToken", this.xStackoneApiSessionToken, "id", this.id, "raw", this.raw, "proxy", this.proxy, "fields", this.fields, "include", this.include, "prefer", this.prefer);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> xStackoneApiSessionToken = Optional.empty();
        private String id;
        private JsonNullable<Boolean> raw = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> proxy = JsonNullable.undefined();
        private JsonNullable<String> fields = JsonNullable.undefined();
        private JsonNullable<String> include = JsonNullable.undefined();
        private Optional<String> prefer = Optional.empty();

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder xStackoneApiSessionToken(String xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
            return this;
        }

        public Builder xStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = xStackoneApiSessionToken;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder raw(boolean raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of((Object)raw);
            return this;
        }

        public Builder raw(JsonNullable<Boolean> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }

        public Builder proxy(Map<String, Object> proxy) {
            Utils.checkNotNull(proxy, "proxy");
            this.proxy = JsonNullable.of(proxy);
            return this;
        }

        public Builder proxy(JsonNullable<? extends Map<String, Object>> proxy) {
            Utils.checkNotNull(proxy, "proxy");
            this.proxy = proxy;
            return this;
        }

        public Builder fields(String fields) {
            Utils.checkNotNull(fields, "fields");
            this.fields = JsonNullable.of((Object)fields);
            return this;
        }

        public Builder fields(JsonNullable<String> fields) {
            Utils.checkNotNull(fields, "fields");
            this.fields = fields;
            return this;
        }

        public Builder include(String include) {
            Utils.checkNotNull(include, "include");
            this.include = JsonNullable.of((Object)include);
            return this;
        }

        public Builder include(JsonNullable<String> include) {
            Utils.checkNotNull(include, "include");
            this.include = include;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public DocumentsGetFileRequest build() {
            return new DocumentsGetFileRequest(this.xAccountId, this.xStackoneApiSessionToken, this.id, this.raw, this.proxy, this.fields, this.include, this.prefer);
        }
    }
}

