/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class IamDeleteUserRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;

    @JsonCreator
    public IamDeleteUserRequest(String xAccountId, String id, Optional<String> prefer) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
    }

    public IamDeleteUserRequest(String xAccountId, String id) {
        this(xAccountId, id, Optional.empty());
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public IamDeleteUserRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public IamDeleteUserRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public IamDeleteUserRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public IamDeleteUserRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamDeleteUserRequest other = (IamDeleteUserRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer);
    }

    public String toString() {
        return Utils.toString(IamDeleteUserRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public IamDeleteUserRequest build() {
            return new IamDeleteUserRequest(this.xAccountId, this.id, this.prefer);
        }
    }
}

