/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LmsCreateAssignmentRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class LmsCreateUserAssignmentRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto;

    @JsonCreator
    public LmsCreateUserAssignmentRequest(String xAccountId, String id, Optional<String> prefer, LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(lmsCreateAssignmentRequestDto, "lmsCreateAssignmentRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.lmsCreateAssignmentRequestDto = lmsCreateAssignmentRequestDto;
    }

    public LmsCreateUserAssignmentRequest(String xAccountId, String id, LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto) {
        this(xAccountId, id, Optional.empty(), lmsCreateAssignmentRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto() {
        return this.lmsCreateAssignmentRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LmsCreateUserAssignmentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsCreateUserAssignmentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LmsCreateUserAssignmentRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public LmsCreateUserAssignmentRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public LmsCreateUserAssignmentRequest withLmsCreateAssignmentRequestDto(LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto) {
        Utils.checkNotNull(lmsCreateAssignmentRequestDto, "lmsCreateAssignmentRequestDto");
        this.lmsCreateAssignmentRequestDto = lmsCreateAssignmentRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsCreateUserAssignmentRequest other = (LmsCreateUserAssignmentRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.lmsCreateAssignmentRequestDto, other.lmsCreateAssignmentRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.lmsCreateAssignmentRequestDto);
    }

    public String toString() {
        return Utils.toString(LmsCreateUserAssignmentRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "lmsCreateAssignmentRequestDto", this.lmsCreateAssignmentRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder lmsCreateAssignmentRequestDto(LmsCreateAssignmentRequestDto lmsCreateAssignmentRequestDto) {
            Utils.checkNotNull(lmsCreateAssignmentRequestDto, "lmsCreateAssignmentRequestDto");
            this.lmsCreateAssignmentRequestDto = lmsCreateAssignmentRequestDto;
            return this;
        }

        public LmsCreateUserAssignmentRequest build() {
            return new LmsCreateUserAssignmentRequest(this.xAccountId, this.id, this.prefer, this.lmsCreateAssignmentRequestDto);
        }
    }
}

