/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LmsUpsertContentRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class LmsUpsertContentRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private LmsUpsertContentRequestDto lmsUpsertContentRequestDto;

    @JsonCreator
    public LmsUpsertContentRequest(String xAccountId, Optional<String> prefer, LmsUpsertContentRequestDto lmsUpsertContentRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(lmsUpsertContentRequestDto, "lmsUpsertContentRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.lmsUpsertContentRequestDto = lmsUpsertContentRequestDto;
    }

    public LmsUpsertContentRequest(String xAccountId, LmsUpsertContentRequestDto lmsUpsertContentRequestDto) {
        this(xAccountId, Optional.empty(), lmsUpsertContentRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public LmsUpsertContentRequestDto lmsUpsertContentRequestDto() {
        return this.lmsUpsertContentRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LmsUpsertContentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsUpsertContentRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public LmsUpsertContentRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public LmsUpsertContentRequest withLmsUpsertContentRequestDto(LmsUpsertContentRequestDto lmsUpsertContentRequestDto) {
        Utils.checkNotNull(lmsUpsertContentRequestDto, "lmsUpsertContentRequestDto");
        this.lmsUpsertContentRequestDto = lmsUpsertContentRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsUpsertContentRequest other = (LmsUpsertContentRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.lmsUpsertContentRequestDto, other.lmsUpsertContentRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.lmsUpsertContentRequestDto);
    }

    public String toString() {
        return Utils.toString(LmsUpsertContentRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "lmsUpsertContentRequestDto", this.lmsUpsertContentRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private LmsUpsertContentRequestDto lmsUpsertContentRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder lmsUpsertContentRequestDto(LmsUpsertContentRequestDto lmsUpsertContentRequestDto) {
            Utils.checkNotNull(lmsUpsertContentRequestDto, "lmsUpsertContentRequestDto");
            this.lmsUpsertContentRequestDto = lmsUpsertContentRequestDto;
            return this;
        }

        public LmsUpsertContentRequest build() {
            return new LmsUpsertContentRequest(this.xAccountId, this.prefer, this.lmsUpsertContentRequestDto);
        }
    }
}

