/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreateInAppTemplateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class MarketingCreateInAppTemplateRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private MarketingCreateInAppTemplateRequestDto marketingCreateInAppTemplateRequestDto;

    @JsonCreator
    public MarketingCreateInAppTemplateRequest(String xAccountId, Optional<String> prefer, MarketingCreateInAppTemplateRequestDto marketingCreateInAppTemplateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(marketingCreateInAppTemplateRequestDto, "marketingCreateInAppTemplateRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.marketingCreateInAppTemplateRequestDto = marketingCreateInAppTemplateRequestDto;
    }

    public MarketingCreateInAppTemplateRequest(String xAccountId, MarketingCreateInAppTemplateRequestDto marketingCreateInAppTemplateRequestDto) {
        this(xAccountId, Optional.empty(), marketingCreateInAppTemplateRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public MarketingCreateInAppTemplateRequestDto marketingCreateInAppTemplateRequestDto() {
        return this.marketingCreateInAppTemplateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MarketingCreateInAppTemplateRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MarketingCreateInAppTemplateRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public MarketingCreateInAppTemplateRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MarketingCreateInAppTemplateRequest withMarketingCreateInAppTemplateRequestDto(MarketingCreateInAppTemplateRequestDto marketingCreateInAppTemplateRequestDto) {
        Utils.checkNotNull(marketingCreateInAppTemplateRequestDto, "marketingCreateInAppTemplateRequestDto");
        this.marketingCreateInAppTemplateRequestDto = marketingCreateInAppTemplateRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingCreateInAppTemplateRequest other = (MarketingCreateInAppTemplateRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.marketingCreateInAppTemplateRequestDto, other.marketingCreateInAppTemplateRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.marketingCreateInAppTemplateRequestDto);
    }

    public String toString() {
        return Utils.toString(MarketingCreateInAppTemplateRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "marketingCreateInAppTemplateRequestDto", this.marketingCreateInAppTemplateRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private MarketingCreateInAppTemplateRequestDto marketingCreateInAppTemplateRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder marketingCreateInAppTemplateRequestDto(MarketingCreateInAppTemplateRequestDto marketingCreateInAppTemplateRequestDto) {
            Utils.checkNotNull(marketingCreateInAppTemplateRequestDto, "marketingCreateInAppTemplateRequestDto");
            this.marketingCreateInAppTemplateRequestDto = marketingCreateInAppTemplateRequestDto;
            return this;
        }

        public MarketingCreateInAppTemplateRequest build() {
            return new MarketingCreateInAppTemplateRequest(this.xAccountId, this.prefer, this.marketingCreateInAppTemplateRequestDto);
        }
    }
}

