/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingTicketCreateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class TicketingCreateTicketRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto;

    @JsonCreator
    public TicketingCreateTicketRequest(String xAccountId, Optional<String> prefer, TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(ticketingTicketCreateRequestDto, "ticketingTicketCreateRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.ticketingTicketCreateRequestDto = ticketingTicketCreateRequestDto;
    }

    public TicketingCreateTicketRequest(String xAccountId, TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto) {
        this(xAccountId, Optional.empty(), ticketingTicketCreateRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto() {
        return this.ticketingTicketCreateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingCreateTicketRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public TicketingCreateTicketRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public TicketingCreateTicketRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public TicketingCreateTicketRequest withTicketingTicketCreateRequestDto(TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto) {
        Utils.checkNotNull(ticketingTicketCreateRequestDto, "ticketingTicketCreateRequestDto");
        this.ticketingTicketCreateRequestDto = ticketingTicketCreateRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingCreateTicketRequest other = (TicketingCreateTicketRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.ticketingTicketCreateRequestDto, other.ticketingTicketCreateRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.ticketingTicketCreateRequestDto);
    }

    public String toString() {
        return Utils.toString(TicketingCreateTicketRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "ticketingTicketCreateRequestDto", this.ticketingTicketCreateRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder ticketingTicketCreateRequestDto(TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto) {
            Utils.checkNotNull(ticketingTicketCreateRequestDto, "ticketingTicketCreateRequestDto");
            this.ticketingTicketCreateRequestDto = ticketingTicketCreateRequestDto;
            return this;
        }

        public TicketingCreateTicketRequest build() {
            return new TicketingCreateTicketRequest(this.xAccountId, this.prefer, this.ticketingTicketCreateRequestDto);
        }
    }
}

