/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingTicketUpdateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class TicketingUpdateTicketRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto;

    @JsonCreator
    public TicketingUpdateTicketRequest(String xAccountId, String id, Optional<String> prefer, TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(ticketingTicketUpdateRequestDto, "ticketingTicketUpdateRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.ticketingTicketUpdateRequestDto = ticketingTicketUpdateRequestDto;
    }

    public TicketingUpdateTicketRequest(String xAccountId, String id, TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto) {
        this(xAccountId, id, Optional.empty(), ticketingTicketUpdateRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto() {
        return this.ticketingTicketUpdateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingUpdateTicketRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public TicketingUpdateTicketRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public TicketingUpdateTicketRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public TicketingUpdateTicketRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public TicketingUpdateTicketRequest withTicketingTicketUpdateRequestDto(TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto) {
        Utils.checkNotNull(ticketingTicketUpdateRequestDto, "ticketingTicketUpdateRequestDto");
        this.ticketingTicketUpdateRequestDto = ticketingTicketUpdateRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingUpdateTicketRequest other = (TicketingUpdateTicketRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.ticketingTicketUpdateRequestDto, other.ticketingTicketUpdateRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.ticketingTicketUpdateRequestDto);
    }

    public String toString() {
        return Utils.toString(TicketingUpdateTicketRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "ticketingTicketUpdateRequestDto", this.ticketingTicketUpdateRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder ticketingTicketUpdateRequestDto(TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto) {
            Utils.checkNotNull(ticketingTicketUpdateRequestDto, "ticketingTicketUpdateRequestDto");
            this.ticketingTicketUpdateRequestDto = ticketingTicketUpdateRequestDto;
            return this;
        }

        public TicketingUpdateTicketRequest build() {
            return new TicketingUpdateTicketRequest(this.xAccountId, this.id, this.prefer, this.ticketingTicketUpdateRequestDto);
        }
    }
}

