/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackone.stackone_client_java.utils.BlockingParser;
import com.stackone.stackone_client_java.utils.EventStreamMessage;
import com.stackone.stackone_client_java.utils.SpeakeasyLogger;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class EventStream<T>
implements Iterable<T>,
AutoCloseable {
    private static final SpeakeasyLogger logger = SpeakeasyLogger.getLogger(EventStream.class);
    private final BlockingParser<EventStreamMessage> parser;
    private final TypeReference<T> typeReference;
    private final ObjectMapper mapper;
    private final Optional<String> terminalMessage;
    private boolean terminated = false;
    private boolean closed = false;

    public EventStream(InputStream in, TypeReference<T> typeReference, ObjectMapper mapper, Optional<String> terminalMessage) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8), 8192);
        this.parser = BlockingParser.forSSE(reader);
        this.typeReference = typeReference;
        this.mapper = mapper;
        this.terminalMessage = terminalMessage;
        logger.debug("EventStream initialized for type: {}", (Object)typeReference.getType().getTypeName());
    }

    public Optional<T> next() throws IOException {
        if (this.terminated) {
            return Optional.empty();
        }
        Optional<EventStreamMessage> message = this.parser.next();
        if (message.isEmpty()) {
            this.terminated = true;
            return Optional.empty();
        }
        EventStreamMessage msg = message.get();
        boolean isTerminal = this.terminalMessage.flatMap(sentinel -> msg.data().map(sentinel::equals)).orElse(false);
        if (isTerminal) {
            this.terminated = true;
            if (logger.isTraceEnabled()) {
                logger.trace("Terminal message encountered in EventStream");
            }
            return Optional.empty();
        }
        Optional<T> result = Optional.of(Utils.asType(msg, this.mapper, this.typeReference));
        if (logger.isTraceEnabled()) {
            logger.trace("EventStream item processed");
        }
        return result;
    }

    public List<T> toList() {
        try {
            List list = this.stream().collect(Collectors.toList());
            return list;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new EventIterator(this);
    }

    public Stream<T> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        logger.debug("EventStream closed");
        this.parser.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    static class EventIterator<T>
    implements Iterator<T> {
        private final EventStream<T> stream;
        private Optional<T> next = Optional.empty();

        EventIterator(EventStream<T> stream) {
            this.stream = stream;
        }

        @Override
        public T next() {
            this.load();
            if (this.next.isEmpty()) {
                throw new NoSuchElementException();
            }
            T v = this.next.get();
            this.next = Optional.empty();
            return v;
        }

        @Override
        public boolean hasNext() {
            this.load();
            return this.next.isPresent();
        }

        private void load() {
            if (this.next.isEmpty()) {
                try {
                    this.next = this.stream.next();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }
}

