/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.operations.AtsListOffersRequest;
import com.stackone.stackone_client_java.models.operations.AtsListOffersResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.stream.Stream;

public class AtsListOffersRequestBuilder {
    private AtsListOffersRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallAtsListOffers sdk;

    public AtsListOffersRequestBuilder(SDKMethodInterfaces.MethodCallAtsListOffers sdk) {
        this.sdk = sdk;
    }

    public AtsListOffersRequestBuilder request(AtsListOffersRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AtsListOffersRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListOffersRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AtsListOffersResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.listOffers(this.request, options);
    }

    public Stream<AtsListOffersResponse> callAsStream() {
        return Utils.stream(() -> Optional.of(this.call()), x -> {
            if (x.statusCode() >= 300) {
                byte[] body = Utils.toByteArrayAndClose(x.rawResponse().body());
                throw new SDKError(x.rawResponse(), x.statusCode(), x.contentType(), body);
            }
            return x.next();
        });
    }
}

