/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.IamGroupResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IamGetGroupResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends IamGroupResult> iamGroupResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public IamGetGroupResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends IamGroupResult> iamGroupResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(iamGroupResult, "iamGroupResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.iamGroupResult = iamGroupResult;
        this.headers = headers;
    }

    public IamGetGroupResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<IamGroupResult> iamGroupResult() {
        return this.iamGroupResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public IamGetGroupResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public IamGetGroupResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public IamGetGroupResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public IamGetGroupResponse withIamGroupResult(IamGroupResult iamGroupResult) {
        Utils.checkNotNull(iamGroupResult, "iamGroupResult");
        this.iamGroupResult = Optional.ofNullable(iamGroupResult);
        return this;
    }

    public IamGetGroupResponse withIamGroupResult(Optional<? extends IamGroupResult> iamGroupResult) {
        Utils.checkNotNull(iamGroupResult, "iamGroupResult");
        this.iamGroupResult = iamGroupResult;
        return this;
    }

    public IamGetGroupResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamGetGroupResponse other = (IamGetGroupResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.iamGroupResult, other.iamGroupResult) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.iamGroupResult, this.headers);
    }

    public String toString() {
        return Utils.toString(IamGetGroupResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "iamGroupResult", this.iamGroupResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends IamGroupResult> iamGroupResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder iamGroupResult(IamGroupResult iamGroupResult) {
            Utils.checkNotNull(iamGroupResult, "iamGroupResult");
            this.iamGroupResult = Optional.ofNullable(iamGroupResult);
            return this;
        }

        public Builder iamGroupResult(Optional<? extends IamGroupResult> iamGroupResult) {
            Utils.checkNotNull(iamGroupResult, "iamGroupResult");
            this.iamGroupResult = iamGroupResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public IamGetGroupResponse build() {
            return new IamGetGroupResponse(this.contentType, this.statusCode, this.rawResponse, this.iamGroupResult, this.headers);
        }
    }
}

