/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.AccountAddressCountry;
import com.stackone.stackone_client_java.models.components.AccountAddressLocationType;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class AccountAddress {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="street_1")
    private JsonNullable<String> street1;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="street_2")
    private JsonNullable<String> street2;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="city")
    private JsonNullable<String> city;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="state")
    private JsonNullable<String> state;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="zip_code")
    private JsonNullable<String> zipCode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="country")
    private JsonNullable<? extends AccountAddressCountry> country;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="location_type")
    private JsonNullable<? extends AccountAddressLocationType> locationType;

    @JsonCreator
    public AccountAddress(@JsonProperty(value="street_1") JsonNullable<String> street1, @JsonProperty(value="street_2") JsonNullable<String> street2, @JsonProperty(value="city") JsonNullable<String> city, @JsonProperty(value="state") JsonNullable<String> state, @JsonProperty(value="zip_code") JsonNullable<String> zipCode, @JsonProperty(value="country") JsonNullable<? extends AccountAddressCountry> country, @JsonProperty(value="location_type") JsonNullable<? extends AccountAddressLocationType> locationType) {
        Utils.checkNotNull(street1, "street1");
        Utils.checkNotNull(street2, "street2");
        Utils.checkNotNull(city, "city");
        Utils.checkNotNull(state, "state");
        Utils.checkNotNull(zipCode, "zipCode");
        Utils.checkNotNull(country, "country");
        Utils.checkNotNull(locationType, "locationType");
        this.street1 = street1;
        this.street2 = street2;
        this.city = city;
        this.state = state;
        this.zipCode = zipCode;
        this.country = country;
        this.locationType = locationType;
    }

    public AccountAddress() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends AccountAddressCountry>)JsonNullable.undefined(), (JsonNullable<? extends AccountAddressLocationType>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> street1() {
        return this.street1;
    }

    @JsonIgnore
    public JsonNullable<String> street2() {
        return this.street2;
    }

    @JsonIgnore
    public JsonNullable<String> city() {
        return this.city;
    }

    @JsonIgnore
    public JsonNullable<String> state() {
        return this.state;
    }

    @JsonIgnore
    public JsonNullable<String> zipCode() {
        return this.zipCode;
    }

    @JsonIgnore
    public JsonNullable<AccountAddressCountry> country() {
        return this.country;
    }

    @JsonIgnore
    public JsonNullable<AccountAddressLocationType> locationType() {
        return this.locationType;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AccountAddress withStreet1(String street1) {
        Utils.checkNotNull(street1, "street1");
        this.street1 = JsonNullable.of((Object)street1);
        return this;
    }

    public AccountAddress withStreet1(JsonNullable<String> street1) {
        Utils.checkNotNull(street1, "street1");
        this.street1 = street1;
        return this;
    }

    public AccountAddress withStreet2(String street2) {
        Utils.checkNotNull(street2, "street2");
        this.street2 = JsonNullable.of((Object)street2);
        return this;
    }

    public AccountAddress withStreet2(JsonNullable<String> street2) {
        Utils.checkNotNull(street2, "street2");
        this.street2 = street2;
        return this;
    }

    public AccountAddress withCity(String city) {
        Utils.checkNotNull(city, "city");
        this.city = JsonNullable.of((Object)city);
        return this;
    }

    public AccountAddress withCity(JsonNullable<String> city) {
        Utils.checkNotNull(city, "city");
        this.city = city;
        return this;
    }

    public AccountAddress withState(String state) {
        Utils.checkNotNull(state, "state");
        this.state = JsonNullable.of((Object)state);
        return this;
    }

    public AccountAddress withState(JsonNullable<String> state) {
        Utils.checkNotNull(state, "state");
        this.state = state;
        return this;
    }

    public AccountAddress withZipCode(String zipCode) {
        Utils.checkNotNull(zipCode, "zipCode");
        this.zipCode = JsonNullable.of((Object)zipCode);
        return this;
    }

    public AccountAddress withZipCode(JsonNullable<String> zipCode) {
        Utils.checkNotNull(zipCode, "zipCode");
        this.zipCode = zipCode;
        return this;
    }

    public AccountAddress withCountry(AccountAddressCountry country) {
        Utils.checkNotNull(country, "country");
        this.country = JsonNullable.of((Object)country);
        return this;
    }

    public AccountAddress withCountry(JsonNullable<? extends AccountAddressCountry> country) {
        Utils.checkNotNull(country, "country");
        this.country = country;
        return this;
    }

    public AccountAddress withLocationType(AccountAddressLocationType locationType) {
        Utils.checkNotNull(locationType, "locationType");
        this.locationType = JsonNullable.of((Object)locationType);
        return this;
    }

    public AccountAddress withLocationType(JsonNullable<? extends AccountAddressLocationType> locationType) {
        Utils.checkNotNull(locationType, "locationType");
        this.locationType = locationType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountAddress other = (AccountAddress)o;
        return Utils.enhancedDeepEquals(this.street1, other.street1) && Utils.enhancedDeepEquals(this.street2, other.street2) && Utils.enhancedDeepEquals(this.city, other.city) && Utils.enhancedDeepEquals(this.state, other.state) && Utils.enhancedDeepEquals(this.zipCode, other.zipCode) && Utils.enhancedDeepEquals(this.country, other.country) && Utils.enhancedDeepEquals(this.locationType, other.locationType);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.street1, this.street2, this.city, this.state, this.zipCode, this.country, this.locationType);
    }

    public String toString() {
        return Utils.toString(AccountAddress.class, "street1", this.street1, "street2", this.street2, "city", this.city, "state", this.state, "zipCode", this.zipCode, "country", this.country, "locationType", this.locationType);
    }

    public static final class Builder {
        private JsonNullable<String> street1 = JsonNullable.undefined();
        private JsonNullable<String> street2 = JsonNullable.undefined();
        private JsonNullable<String> city = JsonNullable.undefined();
        private JsonNullable<String> state = JsonNullable.undefined();
        private JsonNullable<String> zipCode = JsonNullable.undefined();
        private JsonNullable<? extends AccountAddressCountry> country = JsonNullable.undefined();
        private JsonNullable<? extends AccountAddressLocationType> locationType = JsonNullable.undefined();

        private Builder() {
        }

        public Builder street1(String street1) {
            Utils.checkNotNull(street1, "street1");
            this.street1 = JsonNullable.of((Object)street1);
            return this;
        }

        public Builder street1(JsonNullable<String> street1) {
            Utils.checkNotNull(street1, "street1");
            this.street1 = street1;
            return this;
        }

        public Builder street2(String street2) {
            Utils.checkNotNull(street2, "street2");
            this.street2 = JsonNullable.of((Object)street2);
            return this;
        }

        public Builder street2(JsonNullable<String> street2) {
            Utils.checkNotNull(street2, "street2");
            this.street2 = street2;
            return this;
        }

        public Builder city(String city) {
            Utils.checkNotNull(city, "city");
            this.city = JsonNullable.of((Object)city);
            return this;
        }

        public Builder city(JsonNullable<String> city) {
            Utils.checkNotNull(city, "city");
            this.city = city;
            return this;
        }

        public Builder state(String state) {
            Utils.checkNotNull(state, "state");
            this.state = JsonNullable.of((Object)state);
            return this;
        }

        public Builder state(JsonNullable<String> state) {
            Utils.checkNotNull(state, "state");
            this.state = state;
            return this;
        }

        public Builder zipCode(String zipCode) {
            Utils.checkNotNull(zipCode, "zipCode");
            this.zipCode = JsonNullable.of((Object)zipCode);
            return this;
        }

        public Builder zipCode(JsonNullable<String> zipCode) {
            Utils.checkNotNull(zipCode, "zipCode");
            this.zipCode = zipCode;
            return this;
        }

        public Builder country(AccountAddressCountry country) {
            Utils.checkNotNull(country, "country");
            this.country = JsonNullable.of((Object)country);
            return this;
        }

        public Builder country(JsonNullable<? extends AccountAddressCountry> country) {
            Utils.checkNotNull(country, "country");
            this.country = country;
            return this;
        }

        public Builder locationType(AccountAddressLocationType locationType) {
            Utils.checkNotNull(locationType, "locationType");
            this.locationType = JsonNullable.of((Object)locationType);
            return this;
        }

        public Builder locationType(JsonNullable<? extends AccountAddressLocationType> locationType) {
            Utils.checkNotNull(locationType, "locationType");
            this.locationType = locationType;
            return this;
        }

        public AccountAddress build() {
            return new AccountAddress(this.street1, this.street2, this.city, this.state, this.zipCode, this.country, this.locationType);
        }
    }
}

