/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.CategorySourceValue;
import com.stackone.stackone_client_java.models.components.CategoryValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class Hierarchy {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends CategoryValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends CategorySourceValue> sourceValue;

    @JsonCreator
    public Hierarchy(@JsonProperty(value="value") JsonNullable<? extends CategoryValue> value, @JsonProperty(value="source_value") JsonNullable<? extends CategorySourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public Hierarchy() {
        this((JsonNullable<? extends CategoryValue>)JsonNullable.undefined(), (JsonNullable<? extends CategorySourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<CategoryValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<CategorySourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Hierarchy withValue(CategoryValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public Hierarchy withValue(JsonNullable<? extends CategoryValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public Hierarchy withSourceValue(CategorySourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public Hierarchy withSourceValue(JsonNullable<? extends CategorySourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hierarchy other = (Hierarchy)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(Hierarchy.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends CategoryValue> value = JsonNullable.undefined();
        private JsonNullable<? extends CategorySourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(CategoryValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends CategoryValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(CategorySourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends CategorySourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public Hierarchy build() {
            return new Hierarchy(this.value, this.sourceValue);
        }
    }
}

