/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HRISBenefitResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetBenefitResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends HRISBenefitResult> hrisBenefitResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetBenefitResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends HRISBenefitResult> hrisBenefitResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisBenefitResult, "hrisBenefitResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisBenefitResult = hrisBenefitResult;
        this.headers = headers;
    }

    public HrisGetBenefitResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HRISBenefitResult> hrisBenefitResult() {
        return this.hrisBenefitResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisGetBenefitResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetBenefitResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetBenefitResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetBenefitResponse withHRISBenefitResult(HRISBenefitResult hrisBenefitResult) {
        Utils.checkNotNull(hrisBenefitResult, "hrisBenefitResult");
        this.hrisBenefitResult = Optional.ofNullable(hrisBenefitResult);
        return this;
    }

    public HrisGetBenefitResponse withHRISBenefitResult(Optional<? extends HRISBenefitResult> hrisBenefitResult) {
        Utils.checkNotNull(hrisBenefitResult, "hrisBenefitResult");
        this.hrisBenefitResult = hrisBenefitResult;
        return this;
    }

    public HrisGetBenefitResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetBenefitResponse other = (HrisGetBenefitResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisBenefitResult, other.hrisBenefitResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisBenefitResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetBenefitResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisBenefitResult", this.hrisBenefitResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends HRISBenefitResult> hrisBenefitResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisBenefitResult(HRISBenefitResult hrisBenefitResult) {
            Utils.checkNotNull(hrisBenefitResult, "hrisBenefitResult");
            this.hrisBenefitResult = Optional.ofNullable(hrisBenefitResult);
            return this;
        }

        public Builder hrisBenefitResult(Optional<? extends HRISBenefitResult> hrisBenefitResult) {
            Utils.checkNotNull(hrisBenefitResult, "hrisBenefitResult");
            this.hrisBenefitResult = hrisBenefitResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetBenefitResponse build() {
            return new HrisGetBenefitResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisBenefitResult, this.headers);
        }
    }
}

