/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TimeOffBalancesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListEmployeeTimeOffBalancesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TimeOffBalancesPaginated> timeOffBalancesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListEmployeeTimeOffBalancesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TimeOffBalancesPaginated> timeOffBalancesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(timeOffBalancesPaginated, "timeOffBalancesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.timeOffBalancesPaginated = timeOffBalancesPaginated;
        this.headers = headers;
    }

    public HrisListEmployeeTimeOffBalancesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TimeOffBalancesPaginated> timeOffBalancesPaginated() {
        return this.timeOffBalancesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisListEmployeeTimeOffBalancesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmployeeTimeOffBalancesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmployeeTimeOffBalancesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmployeeTimeOffBalancesResponse withTimeOffBalancesPaginated(TimeOffBalancesPaginated timeOffBalancesPaginated) {
        Utils.checkNotNull(timeOffBalancesPaginated, "timeOffBalancesPaginated");
        this.timeOffBalancesPaginated = Optional.ofNullable(timeOffBalancesPaginated);
        return this;
    }

    public HrisListEmployeeTimeOffBalancesResponse withTimeOffBalancesPaginated(Optional<? extends TimeOffBalancesPaginated> timeOffBalancesPaginated) {
        Utils.checkNotNull(timeOffBalancesPaginated, "timeOffBalancesPaginated");
        this.timeOffBalancesPaginated = timeOffBalancesPaginated;
        return this;
    }

    public HrisListEmployeeTimeOffBalancesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeTimeOffBalancesResponse other = (HrisListEmployeeTimeOffBalancesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.timeOffBalancesPaginated, other.timeOffBalancesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.timeOffBalancesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmployeeTimeOffBalancesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "timeOffBalancesPaginated", this.timeOffBalancesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TimeOffBalancesPaginated> timeOffBalancesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder timeOffBalancesPaginated(TimeOffBalancesPaginated timeOffBalancesPaginated) {
            Utils.checkNotNull(timeOffBalancesPaginated, "timeOffBalancesPaginated");
            this.timeOffBalancesPaginated = Optional.ofNullable(timeOffBalancesPaginated);
            return this;
        }

        public Builder timeOffBalancesPaginated(Optional<? extends TimeOffBalancesPaginated> timeOffBalancesPaginated) {
            Utils.checkNotNull(timeOffBalancesPaginated, "timeOffBalancesPaginated");
            this.timeOffBalancesPaginated = timeOffBalancesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListEmployeeTimeOffBalancesResponse build() {
            return new HrisListEmployeeTimeOffBalancesResponse(this.contentType, this.statusCode, this.rawResponse, this.timeOffBalancesPaginated, this.headers);
        }
    }
}

