/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ContentBlocksPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingListContentBlocksResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ContentBlocksPaginated> contentBlocksPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingListContentBlocksResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ContentBlocksPaginated> contentBlocksPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(contentBlocksPaginated, "contentBlocksPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.contentBlocksPaginated = contentBlocksPaginated;
        this.headers = headers;
    }

    public MarketingListContentBlocksResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ContentBlocksPaginated> contentBlocksPaginated() {
        return this.contentBlocksPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MarketingListContentBlocksResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingListContentBlocksResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingListContentBlocksResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingListContentBlocksResponse withContentBlocksPaginated(ContentBlocksPaginated contentBlocksPaginated) {
        Utils.checkNotNull(contentBlocksPaginated, "contentBlocksPaginated");
        this.contentBlocksPaginated = Optional.ofNullable(contentBlocksPaginated);
        return this;
    }

    public MarketingListContentBlocksResponse withContentBlocksPaginated(Optional<? extends ContentBlocksPaginated> contentBlocksPaginated) {
        Utils.checkNotNull(contentBlocksPaginated, "contentBlocksPaginated");
        this.contentBlocksPaginated = contentBlocksPaginated;
        return this;
    }

    public MarketingListContentBlocksResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingListContentBlocksResponse other = (MarketingListContentBlocksResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.contentBlocksPaginated, other.contentBlocksPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.contentBlocksPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingListContentBlocksResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "contentBlocksPaginated", this.contentBlocksPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ContentBlocksPaginated> contentBlocksPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder contentBlocksPaginated(ContentBlocksPaginated contentBlocksPaginated) {
            Utils.checkNotNull(contentBlocksPaginated, "contentBlocksPaginated");
            this.contentBlocksPaginated = Optional.ofNullable(contentBlocksPaginated);
            return this;
        }

        public Builder contentBlocksPaginated(Optional<? extends ContentBlocksPaginated> contentBlocksPaginated) {
            Utils.checkNotNull(contentBlocksPaginated, "contentBlocksPaginated");
            this.contentBlocksPaginated = contentBlocksPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MarketingListContentBlocksResponse build() {
            return new MarketingListContentBlocksResponse(this.contentType, this.statusCode, this.rawResponse, this.contentBlocksPaginated, this.headers);
        }
    }
}

