/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.EmailTemplatesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingListEmailTemplatesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends EmailTemplatesPaginated> emailTemplatesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingListEmailTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends EmailTemplatesPaginated> emailTemplatesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(emailTemplatesPaginated, "emailTemplatesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.emailTemplatesPaginated = emailTemplatesPaginated;
        this.headers = headers;
    }

    public MarketingListEmailTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<EmailTemplatesPaginated> emailTemplatesPaginated() {
        return this.emailTemplatesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MarketingListEmailTemplatesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingListEmailTemplatesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingListEmailTemplatesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingListEmailTemplatesResponse withEmailTemplatesPaginated(EmailTemplatesPaginated emailTemplatesPaginated) {
        Utils.checkNotNull(emailTemplatesPaginated, "emailTemplatesPaginated");
        this.emailTemplatesPaginated = Optional.ofNullable(emailTemplatesPaginated);
        return this;
    }

    public MarketingListEmailTemplatesResponse withEmailTemplatesPaginated(Optional<? extends EmailTemplatesPaginated> emailTemplatesPaginated) {
        Utils.checkNotNull(emailTemplatesPaginated, "emailTemplatesPaginated");
        this.emailTemplatesPaginated = emailTemplatesPaginated;
        return this;
    }

    public MarketingListEmailTemplatesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingListEmailTemplatesResponse other = (MarketingListEmailTemplatesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.emailTemplatesPaginated, other.emailTemplatesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.emailTemplatesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingListEmailTemplatesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "emailTemplatesPaginated", this.emailTemplatesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends EmailTemplatesPaginated> emailTemplatesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder emailTemplatesPaginated(EmailTemplatesPaginated emailTemplatesPaginated) {
            Utils.checkNotNull(emailTemplatesPaginated, "emailTemplatesPaginated");
            this.emailTemplatesPaginated = Optional.ofNullable(emailTemplatesPaginated);
            return this;
        }

        public Builder emailTemplatesPaginated(Optional<? extends EmailTemplatesPaginated> emailTemplatesPaginated) {
            Utils.checkNotNull(emailTemplatesPaginated, "emailTemplatesPaginated");
            this.emailTemplatesPaginated = emailTemplatesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MarketingListEmailTemplatesResponse build() {
            return new MarketingListEmailTemplatesResponse(this.contentType, this.statusCode, this.rawResponse, this.emailTemplatesPaginated, this.headers);
        }
    }
}

