/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.InAppTemplatesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingListInAppTemplatesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends InAppTemplatesPaginated> inAppTemplatesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingListInAppTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends InAppTemplatesPaginated> inAppTemplatesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(inAppTemplatesPaginated, "inAppTemplatesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.inAppTemplatesPaginated = inAppTemplatesPaginated;
        this.headers = headers;
    }

    public MarketingListInAppTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<InAppTemplatesPaginated> inAppTemplatesPaginated() {
        return this.inAppTemplatesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MarketingListInAppTemplatesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingListInAppTemplatesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingListInAppTemplatesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingListInAppTemplatesResponse withInAppTemplatesPaginated(InAppTemplatesPaginated inAppTemplatesPaginated) {
        Utils.checkNotNull(inAppTemplatesPaginated, "inAppTemplatesPaginated");
        this.inAppTemplatesPaginated = Optional.ofNullable(inAppTemplatesPaginated);
        return this;
    }

    public MarketingListInAppTemplatesResponse withInAppTemplatesPaginated(Optional<? extends InAppTemplatesPaginated> inAppTemplatesPaginated) {
        Utils.checkNotNull(inAppTemplatesPaginated, "inAppTemplatesPaginated");
        this.inAppTemplatesPaginated = inAppTemplatesPaginated;
        return this;
    }

    public MarketingListInAppTemplatesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingListInAppTemplatesResponse other = (MarketingListInAppTemplatesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.inAppTemplatesPaginated, other.inAppTemplatesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.inAppTemplatesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingListInAppTemplatesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "inAppTemplatesPaginated", this.inAppTemplatesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends InAppTemplatesPaginated> inAppTemplatesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder inAppTemplatesPaginated(InAppTemplatesPaginated inAppTemplatesPaginated) {
            Utils.checkNotNull(inAppTemplatesPaginated, "inAppTemplatesPaginated");
            this.inAppTemplatesPaginated = Optional.ofNullable(inAppTemplatesPaginated);
            return this;
        }

        public Builder inAppTemplatesPaginated(Optional<? extends InAppTemplatesPaginated> inAppTemplatesPaginated) {
            Utils.checkNotNull(inAppTemplatesPaginated, "inAppTemplatesPaginated");
            this.inAppTemplatesPaginated = inAppTemplatesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MarketingListInAppTemplatesResponse build() {
            return new MarketingListInAppTemplatesResponse(this.contentType, this.statusCode, this.rawResponse, this.inAppTemplatesPaginated, this.headers);
        }
    }
}

