/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class HrisCreateTimeOffRequestDto {
    /**
     * The approver ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("approver_id")
    private JsonNullable<String> approverId;

    /**
     * The status of the time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends HrisCreateTimeOffRequestDtoStatus> status;

    /**
     * The type of the time off request
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    @Deprecated
    private JsonNullable<? extends HrisCreateTimeOffRequestDtoType> type;

    /**
     * The start date of the time off request (ISO8601 date-time without timezone)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_date")
    private JsonNullable<String> startDate;

    /**
     * Inclusive end date of the time off request (ISO8601 date-time without timezone). The time off includes this day
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_date")
    private JsonNullable<String> endDate;

    /**
     * True if the start of the time off request begins half way through the day
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_half_day")
    private JsonNullable<? extends HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay;

    /**
     * True if the end of the time off request ends half way through the day
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_half_day")
    private JsonNullable<? extends HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay;

    /**
     * The time off policy id associated with this time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("time_off_policy_id")
    private JsonNullable<String> timeOffPolicyId;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("reason")
    private JsonNullable<? extends HrisCreateTimeOffRequestDtoReason> reason;

    /**
     * Allows users to provide additional context or notes for their time off request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("comment")
    private JsonNullable<String> comment;

    /**
     * Value to pass through to the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;

    @JsonCreator
    public HrisCreateTimeOffRequestDto(
            @JsonProperty("approver_id") JsonNullable<String> approverId,
            @JsonProperty("status") JsonNullable<? extends HrisCreateTimeOffRequestDtoStatus> status,
            @JsonProperty("type") JsonNullable<? extends HrisCreateTimeOffRequestDtoType> type,
            @JsonProperty("start_date") JsonNullable<String> startDate,
            @JsonProperty("end_date") JsonNullable<String> endDate,
            @JsonProperty("start_half_day") JsonNullable<? extends HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay,
            @JsonProperty("end_half_day") JsonNullable<? extends HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay,
            @JsonProperty("time_off_policy_id") JsonNullable<String> timeOffPolicyId,
            @JsonProperty("reason") JsonNullable<? extends HrisCreateTimeOffRequestDtoReason> reason,
            @JsonProperty("comment") JsonNullable<String> comment,
            @JsonProperty("passthrough") JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(approverId, "approverId");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(startDate, "startDate");
        Utils.checkNotNull(endDate, "endDate");
        Utils.checkNotNull(startHalfDay, "startHalfDay");
        Utils.checkNotNull(endHalfDay, "endHalfDay");
        Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
        Utils.checkNotNull(reason, "reason");
        Utils.checkNotNull(comment, "comment");
        Utils.checkNotNull(passthrough, "passthrough");
        this.approverId = approverId;
        this.status = status;
        this.type = type;
        this.startDate = startDate;
        this.endDate = endDate;
        this.startHalfDay = startHalfDay;
        this.endHalfDay = endHalfDay;
        this.timeOffPolicyId = timeOffPolicyId;
        this.reason = reason;
        this.comment = comment;
        this.passthrough = passthrough;
    }
    
    public HrisCreateTimeOffRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The approver ID
     */
    @JsonIgnore
    public JsonNullable<String> approverId() {
        return approverId;
    }

    /**
     * The status of the time off request
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisCreateTimeOffRequestDtoStatus> status() {
        return (JsonNullable<HrisCreateTimeOffRequestDtoStatus>) status;
    }

    /**
     * The type of the time off request
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisCreateTimeOffRequestDtoType> type() {
        return (JsonNullable<HrisCreateTimeOffRequestDtoType>) type;
    }

    /**
     * The start date of the time off request (ISO8601 date-time without timezone)
     */
    @JsonIgnore
    public JsonNullable<String> startDate() {
        return startDate;
    }

    /**
     * Inclusive end date of the time off request (ISO8601 date-time without timezone). The time off includes this day
     */
    @JsonIgnore
    public JsonNullable<String> endDate() {
        return endDate;
    }

    /**
     * True if the start of the time off request begins half way through the day
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay() {
        return (JsonNullable<HrisCreateTimeOffRequestDtoStartHalfDay>) startHalfDay;
    }

    /**
     * True if the end of the time off request ends half way through the day
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay() {
        return (JsonNullable<HrisCreateTimeOffRequestDtoEndHalfDay>) endHalfDay;
    }

    /**
     * The time off policy id associated with this time off request
     */
    @JsonIgnore
    public JsonNullable<String> timeOffPolicyId() {
        return timeOffPolicyId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisCreateTimeOffRequestDtoReason> reason() {
        return (JsonNullable<HrisCreateTimeOffRequestDtoReason>) reason;
    }

    /**
     * Allows users to provide additional context or notes for their time off request
     */
    @JsonIgnore
    public JsonNullable<String> comment() {
        return comment;
    }

    /**
     * Value to pass through to the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return (JsonNullable<Map<String, Object>>) passthrough;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The approver ID
     */
    public HrisCreateTimeOffRequestDto withApproverId(String approverId) {
        Utils.checkNotNull(approverId, "approverId");
        this.approverId = JsonNullable.of(approverId);
        return this;
    }

    /**
     * The approver ID
     */
    public HrisCreateTimeOffRequestDto withApproverId(JsonNullable<String> approverId) {
        Utils.checkNotNull(approverId, "approverId");
        this.approverId = approverId;
        return this;
    }

    /**
     * The status of the time off request
     */
    public HrisCreateTimeOffRequestDto withStatus(HrisCreateTimeOffRequestDtoStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * The status of the time off request
     */
    public HrisCreateTimeOffRequestDto withStatus(JsonNullable<? extends HrisCreateTimeOffRequestDtoStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The type of the time off request
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public HrisCreateTimeOffRequestDto withType(HrisCreateTimeOffRequestDtoType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The type of the time off request
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public HrisCreateTimeOffRequestDto withType(JsonNullable<? extends HrisCreateTimeOffRequestDtoType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The start date of the time off request (ISO8601 date-time without timezone)
     */
    public HrisCreateTimeOffRequestDto withStartDate(String startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = JsonNullable.of(startDate);
        return this;
    }

    /**
     * The start date of the time off request (ISO8601 date-time without timezone)
     */
    public HrisCreateTimeOffRequestDto withStartDate(JsonNullable<String> startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    /**
     * Inclusive end date of the time off request (ISO8601 date-time without timezone). The time off includes this day
     */
    public HrisCreateTimeOffRequestDto withEndDate(String endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = JsonNullable.of(endDate);
        return this;
    }

    /**
     * Inclusive end date of the time off request (ISO8601 date-time without timezone). The time off includes this day
     */
    public HrisCreateTimeOffRequestDto withEndDate(JsonNullable<String> endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = endDate;
        return this;
    }

    /**
     * True if the start of the time off request begins half way through the day
     */
    public HrisCreateTimeOffRequestDto withStartHalfDay(HrisCreateTimeOffRequestDtoStartHalfDay startHalfDay) {
        Utils.checkNotNull(startHalfDay, "startHalfDay");
        this.startHalfDay = JsonNullable.of(startHalfDay);
        return this;
    }

    /**
     * True if the start of the time off request begins half way through the day
     */
    public HrisCreateTimeOffRequestDto withStartHalfDay(JsonNullable<? extends HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay) {
        Utils.checkNotNull(startHalfDay, "startHalfDay");
        this.startHalfDay = startHalfDay;
        return this;
    }

    /**
     * True if the end of the time off request ends half way through the day
     */
    public HrisCreateTimeOffRequestDto withEndHalfDay(HrisCreateTimeOffRequestDtoEndHalfDay endHalfDay) {
        Utils.checkNotNull(endHalfDay, "endHalfDay");
        this.endHalfDay = JsonNullable.of(endHalfDay);
        return this;
    }

    /**
     * True if the end of the time off request ends half way through the day
     */
    public HrisCreateTimeOffRequestDto withEndHalfDay(JsonNullable<? extends HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay) {
        Utils.checkNotNull(endHalfDay, "endHalfDay");
        this.endHalfDay = endHalfDay;
        return this;
    }

    /**
     * The time off policy id associated with this time off request
     */
    public HrisCreateTimeOffRequestDto withTimeOffPolicyId(String timeOffPolicyId) {
        Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
        this.timeOffPolicyId = JsonNullable.of(timeOffPolicyId);
        return this;
    }

    /**
     * The time off policy id associated with this time off request
     */
    public HrisCreateTimeOffRequestDto withTimeOffPolicyId(JsonNullable<String> timeOffPolicyId) {
        Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
        this.timeOffPolicyId = timeOffPolicyId;
        return this;
    }

    public HrisCreateTimeOffRequestDto withReason(HrisCreateTimeOffRequestDtoReason reason) {
        Utils.checkNotNull(reason, "reason");
        this.reason = JsonNullable.of(reason);
        return this;
    }

    public HrisCreateTimeOffRequestDto withReason(JsonNullable<? extends HrisCreateTimeOffRequestDtoReason> reason) {
        Utils.checkNotNull(reason, "reason");
        this.reason = reason;
        return this;
    }

    /**
     * Allows users to provide additional context or notes for their time off request
     */
    public HrisCreateTimeOffRequestDto withComment(String comment) {
        Utils.checkNotNull(comment, "comment");
        this.comment = JsonNullable.of(comment);
        return this;
    }

    /**
     * Allows users to provide additional context or notes for their time off request
     */
    public HrisCreateTimeOffRequestDto withComment(JsonNullable<String> comment) {
        Utils.checkNotNull(comment, "comment");
        this.comment = comment;
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public HrisCreateTimeOffRequestDto withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public HrisCreateTimeOffRequestDto withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisCreateTimeOffRequestDto other = (HrisCreateTimeOffRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.approverId, other.approverId) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.startDate, other.startDate) &&
            Utils.enhancedDeepEquals(this.endDate, other.endDate) &&
            Utils.enhancedDeepEquals(this.startHalfDay, other.startHalfDay) &&
            Utils.enhancedDeepEquals(this.endHalfDay, other.endHalfDay) &&
            Utils.enhancedDeepEquals(this.timeOffPolicyId, other.timeOffPolicyId) &&
            Utils.enhancedDeepEquals(this.reason, other.reason) &&
            Utils.enhancedDeepEquals(this.comment, other.comment) &&
            Utils.enhancedDeepEquals(this.passthrough, other.passthrough);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            approverId, status, type,
            startDate, endDate, startHalfDay,
            endHalfDay, timeOffPolicyId, reason,
            comment, passthrough);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisCreateTimeOffRequestDto.class,
                "approverId", approverId,
                "status", status,
                "type", type,
                "startDate", startDate,
                "endDate", endDate,
                "startHalfDay", startHalfDay,
                "endHalfDay", endHalfDay,
                "timeOffPolicyId", timeOffPolicyId,
                "reason", reason,
                "comment", comment,
                "passthrough", passthrough);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> approverId = JsonNullable.undefined();

        private JsonNullable<? extends HrisCreateTimeOffRequestDtoStatus> status = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<? extends HrisCreateTimeOffRequestDtoType> type = JsonNullable.undefined();

        private JsonNullable<String> startDate = JsonNullable.undefined();

        private JsonNullable<String> endDate = JsonNullable.undefined();

        private JsonNullable<? extends HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay = JsonNullable.undefined();

        private JsonNullable<? extends HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay = JsonNullable.undefined();

        private JsonNullable<String> timeOffPolicyId = JsonNullable.undefined();

        private JsonNullable<? extends HrisCreateTimeOffRequestDtoReason> reason = JsonNullable.undefined();

        private JsonNullable<String> comment = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The approver ID
         */
        public Builder approverId(String approverId) {
            Utils.checkNotNull(approverId, "approverId");
            this.approverId = JsonNullable.of(approverId);
            return this;
        }

        /**
         * The approver ID
         */
        public Builder approverId(JsonNullable<String> approverId) {
            Utils.checkNotNull(approverId, "approverId");
            this.approverId = approverId;
            return this;
        }


        /**
         * The status of the time off request
         */
        public Builder status(HrisCreateTimeOffRequestDtoStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * The status of the time off request
         */
        public Builder status(JsonNullable<? extends HrisCreateTimeOffRequestDtoStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * The type of the time off request
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder type(HrisCreateTimeOffRequestDtoType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The type of the time off request
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder type(JsonNullable<? extends HrisCreateTimeOffRequestDtoType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * The start date of the time off request (ISO8601 date-time without timezone)
         */
        public Builder startDate(String startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = JsonNullable.of(startDate);
            return this;
        }

        /**
         * The start date of the time off request (ISO8601 date-time without timezone)
         */
        public Builder startDate(JsonNullable<String> startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = startDate;
            return this;
        }


        /**
         * Inclusive end date of the time off request (ISO8601 date-time without timezone). The time off includes this day
         */
        public Builder endDate(String endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = JsonNullable.of(endDate);
            return this;
        }

        /**
         * Inclusive end date of the time off request (ISO8601 date-time without timezone). The time off includes this day
         */
        public Builder endDate(JsonNullable<String> endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = endDate;
            return this;
        }


        /**
         * True if the start of the time off request begins half way through the day
         */
        public Builder startHalfDay(HrisCreateTimeOffRequestDtoStartHalfDay startHalfDay) {
            Utils.checkNotNull(startHalfDay, "startHalfDay");
            this.startHalfDay = JsonNullable.of(startHalfDay);
            return this;
        }

        /**
         * True if the start of the time off request begins half way through the day
         */
        public Builder startHalfDay(JsonNullable<? extends HrisCreateTimeOffRequestDtoStartHalfDay> startHalfDay) {
            Utils.checkNotNull(startHalfDay, "startHalfDay");
            this.startHalfDay = startHalfDay;
            return this;
        }


        /**
         * True if the end of the time off request ends half way through the day
         */
        public Builder endHalfDay(HrisCreateTimeOffRequestDtoEndHalfDay endHalfDay) {
            Utils.checkNotNull(endHalfDay, "endHalfDay");
            this.endHalfDay = JsonNullable.of(endHalfDay);
            return this;
        }

        /**
         * True if the end of the time off request ends half way through the day
         */
        public Builder endHalfDay(JsonNullable<? extends HrisCreateTimeOffRequestDtoEndHalfDay> endHalfDay) {
            Utils.checkNotNull(endHalfDay, "endHalfDay");
            this.endHalfDay = endHalfDay;
            return this;
        }


        /**
         * The time off policy id associated with this time off request
         */
        public Builder timeOffPolicyId(String timeOffPolicyId) {
            Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
            this.timeOffPolicyId = JsonNullable.of(timeOffPolicyId);
            return this;
        }

        /**
         * The time off policy id associated with this time off request
         */
        public Builder timeOffPolicyId(JsonNullable<String> timeOffPolicyId) {
            Utils.checkNotNull(timeOffPolicyId, "timeOffPolicyId");
            this.timeOffPolicyId = timeOffPolicyId;
            return this;
        }


        public Builder reason(HrisCreateTimeOffRequestDtoReason reason) {
            Utils.checkNotNull(reason, "reason");
            this.reason = JsonNullable.of(reason);
            return this;
        }

        public Builder reason(JsonNullable<? extends HrisCreateTimeOffRequestDtoReason> reason) {
            Utils.checkNotNull(reason, "reason");
            this.reason = reason;
            return this;
        }


        /**
         * Allows users to provide additional context or notes for their time off request
         */
        public Builder comment(String comment) {
            Utils.checkNotNull(comment, "comment");
            this.comment = JsonNullable.of(comment);
            return this;
        }

        /**
         * Allows users to provide additional context or notes for their time off request
         */
        public Builder comment(JsonNullable<String> comment) {
            Utils.checkNotNull(comment, "comment");
            this.comment = comment;
            return this;
        }


        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }

        public HrisCreateTimeOffRequestDto build() {

            return new HrisCreateTimeOffRequestDto(
                approverId, status, type,
                startDate, endDate, startHalfDay,
                endHalfDay, timeOffPolicyId, reason,
                comment, passthrough);
        }

    }
}
