/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.UnifiedUploadRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsUploadApplicationDocumentRequest;
import com.stackone.stackone_client_java.models.operations.AtsUploadApplicationDocumentResponse;
import com.stackone.stackone_client_java.operations.AtsUploadApplicationDocumentOperation;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsUploadApplicationDocumentRequestBuilder {
    private String xAccountId;
    private String id;
    private UnifiedUploadRequestDto unifiedUploadRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AtsUploadApplicationDocumentRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsUploadApplicationDocumentRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder unifiedUploadRequestDto(UnifiedUploadRequestDto unifiedUploadRequestDto) {
        Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
        this.unifiedUploadRequestDto = unifiedUploadRequestDto;
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsUploadApplicationDocumentRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private AtsUploadApplicationDocumentRequest buildRequest() {
        AtsUploadApplicationDocumentRequest request = new AtsUploadApplicationDocumentRequest(this.xAccountId, this.id, this.unifiedUploadRequestDto);
        return request;
    }

    public AtsUploadApplicationDocumentResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsUploadApplicationDocumentOperation operation = new AtsUploadApplicationDocumentOperation(this.sdkConfiguration, options);
        AtsUploadApplicationDocumentRequest request = this.buildRequest();
        return (AtsUploadApplicationDocumentResponse)operation.handleResponse(operation.doRequest(request));
    }
}

