/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class NoteValue {
    public static final NoteValue PRIVATE = new NoteValue("private");
    public static final NoteValue PUBLIC = new NoteValue("public");
    public static final NoteValue UNMAPPED_VALUE = new NoteValue("unmapped_value");
    private static final Map<String, NoteValue> values = NoteValue.createValuesMap();
    private static final Map<String, NoteValueEnum> enums = NoteValue.createEnumsMap();
    private final String value;

    private NoteValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NoteValue of(String value) {
        Class<NoteValue> clazz = NoteValue.class;
        synchronized (NoteValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new NoteValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<NoteValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NoteValue other = (NoteValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "NoteValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NoteValue[] values() {
        Class<NoteValue> clazz = NoteValue.class;
        synchronized (NoteValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new NoteValue[0]);
        }
    }

    private static final Map<String, NoteValue> createValuesMap() {
        LinkedHashMap<String, NoteValue> map = new LinkedHashMap<String, NoteValue>();
        map.put("private", PRIVATE);
        map.put("public", PUBLIC);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, NoteValueEnum> createEnumsMap() {
        HashMap<String, NoteValueEnum> map = new HashMap<String, NoteValueEnum>();
        map.put("private", NoteValueEnum.PRIVATE);
        map.put("public", NoteValueEnum.PUBLIC);
        map.put("unmapped_value", NoteValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum NoteValueEnum {
        PRIVATE("private"),
        PUBLIC("public"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private NoteValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<NoteValue> {
        protected _Deserializer() {
            super(NoteValue.class);
        }

        public NoteValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return NoteValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<NoteValue> {
        protected _Serializer() {
            super(NoteValue.class);
        }

        public void serialize(NoteValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

