/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.CrmListAccountsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListAccountsResponse;
import com.stackone.stackone_client_java.operations.CrmListAccountsOperation;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class CrmListAccountsRequestBuilder {
    private CrmListAccountsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public CrmListAccountsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CrmListAccountsRequestBuilder request(CrmListAccountsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public CrmListAccountsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CrmListAccountsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CrmListAccountsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CrmListAccountsOperation operation = new CrmListAccountsOperation(this.sdkConfiguration, options);
        return (CrmListAccountsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<CrmListAccountsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CrmListAccountsOperation operation = new CrmListAccountsOperation(this.sdkConfiguration, options);
        Paginator<CrmListAccountsRequest, String> iterator = new Paginator<CrmListAccountsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), CrmListAccountsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<CrmListAccountsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

