/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CompletionsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LmsListUserCompletionsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends CompletionsPaginated> completionsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public LmsListUserCompletionsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends CompletionsPaginated> completionsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(completionsPaginated, "completionsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.completionsPaginated = completionsPaginated;
        this.headers = headers;
    }

    public LmsListUserCompletionsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CompletionsPaginated> completionsPaginated() {
        return this.completionsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LmsListUserCompletionsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public LmsListUserCompletionsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public LmsListUserCompletionsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public LmsListUserCompletionsResponse withCompletionsPaginated(CompletionsPaginated completionsPaginated) {
        Utils.checkNotNull(completionsPaginated, "completionsPaginated");
        this.completionsPaginated = Optional.ofNullable(completionsPaginated);
        return this;
    }

    public LmsListUserCompletionsResponse withCompletionsPaginated(Optional<? extends CompletionsPaginated> completionsPaginated) {
        Utils.checkNotNull(completionsPaginated, "completionsPaginated");
        this.completionsPaginated = completionsPaginated;
        return this;
    }

    public LmsListUserCompletionsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsListUserCompletionsResponse other = (LmsListUserCompletionsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.completionsPaginated, other.completionsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.completionsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(LmsListUserCompletionsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "completionsPaginated", this.completionsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends CompletionsPaginated> completionsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder completionsPaginated(CompletionsPaginated completionsPaginated) {
            Utils.checkNotNull(completionsPaginated, "completionsPaginated");
            this.completionsPaginated = Optional.ofNullable(completionsPaginated);
            return this;
        }

        public Builder completionsPaginated(Optional<? extends CompletionsPaginated> completionsPaginated) {
            Utils.checkNotNull(completionsPaginated, "completionsPaginated");
            this.completionsPaginated = completionsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public LmsListUserCompletionsResponse build() {
            return new LmsListUserCompletionsResponse(this.contentType, this.statusCode, this.rawResponse, this.completionsPaginated, this.headers);
        }
    }
}

