/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;


public class Position {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Job ID from the HRIS provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("job_id")
    private JsonNullable<String> jobId;

    /**
     * Title of the position
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("title")
    private JsonNullable<String> title;

    /**
     * Description of the position
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * Department ID associated with the position
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("department_id")
    private JsonNullable<String> departmentId;

    /**
     * Location ID associated with the position
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("location_id")
    private JsonNullable<String> locationId;

    /**
     * Employment type for the position
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employment_type")
    private JsonNullable<String> employmentType;

    /**
     * Status of the position
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends PositionStatus> status;

    /**
     * Date when the position was posted
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("posted_date")
    private JsonNullable<OffsetDateTime> postedDate;

    @JsonCreator
    public Position(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("job_id") JsonNullable<String> jobId,
            @JsonProperty("title") JsonNullable<String> title,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("department_id") JsonNullable<String> departmentId,
            @JsonProperty("location_id") JsonNullable<String> locationId,
            @JsonProperty("employment_type") JsonNullable<String> employmentType,
            @JsonProperty("status") JsonNullable<? extends PositionStatus> status,
            @JsonProperty("posted_date") JsonNullable<OffsetDateTime> postedDate) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(jobId, "jobId");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(departmentId, "departmentId");
        Utils.checkNotNull(locationId, "locationId");
        Utils.checkNotNull(employmentType, "employmentType");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(postedDate, "postedDate");
        this.id = id;
        this.remoteId = remoteId;
        this.jobId = jobId;
        this.title = title;
        this.description = description;
        this.departmentId = departmentId;
        this.locationId = locationId;
        this.employmentType = employmentType;
        this.status = status;
        this.postedDate = postedDate;
    }
    
    public Position() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Job ID from the HRIS provider
     */
    @JsonIgnore
    public JsonNullable<String> jobId() {
        return jobId;
    }

    /**
     * Title of the position
     */
    @JsonIgnore
    public JsonNullable<String> title() {
        return title;
    }

    /**
     * Description of the position
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * Department ID associated with the position
     */
    @JsonIgnore
    public JsonNullable<String> departmentId() {
        return departmentId;
    }

    /**
     * Location ID associated with the position
     */
    @JsonIgnore
    public JsonNullable<String> locationId() {
        return locationId;
    }

    /**
     * Employment type for the position
     */
    @JsonIgnore
    public JsonNullable<String> employmentType() {
        return employmentType;
    }

    /**
     * Status of the position
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<PositionStatus> status() {
        return (JsonNullable<PositionStatus>) status;
    }

    /**
     * Date when the position was posted
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> postedDate() {
        return postedDate;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public Position withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Position withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Position withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Position withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Job ID from the HRIS provider
     */
    public Position withJobId(String jobId) {
        Utils.checkNotNull(jobId, "jobId");
        this.jobId = JsonNullable.of(jobId);
        return this;
    }

    /**
     * Job ID from the HRIS provider
     */
    public Position withJobId(JsonNullable<String> jobId) {
        Utils.checkNotNull(jobId, "jobId");
        this.jobId = jobId;
        return this;
    }

    /**
     * Title of the position
     */
    public Position withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = JsonNullable.of(title);
        return this;
    }

    /**
     * Title of the position
     */
    public Position withTitle(JsonNullable<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * Description of the position
     */
    public Position withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * Description of the position
     */
    public Position withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * Department ID associated with the position
     */
    public Position withDepartmentId(String departmentId) {
        Utils.checkNotNull(departmentId, "departmentId");
        this.departmentId = JsonNullable.of(departmentId);
        return this;
    }

    /**
     * Department ID associated with the position
     */
    public Position withDepartmentId(JsonNullable<String> departmentId) {
        Utils.checkNotNull(departmentId, "departmentId");
        this.departmentId = departmentId;
        return this;
    }

    /**
     * Location ID associated with the position
     */
    public Position withLocationId(String locationId) {
        Utils.checkNotNull(locationId, "locationId");
        this.locationId = JsonNullable.of(locationId);
        return this;
    }

    /**
     * Location ID associated with the position
     */
    public Position withLocationId(JsonNullable<String> locationId) {
        Utils.checkNotNull(locationId, "locationId");
        this.locationId = locationId;
        return this;
    }

    /**
     * Employment type for the position
     */
    public Position withEmploymentType(String employmentType) {
        Utils.checkNotNull(employmentType, "employmentType");
        this.employmentType = JsonNullable.of(employmentType);
        return this;
    }

    /**
     * Employment type for the position
     */
    public Position withEmploymentType(JsonNullable<String> employmentType) {
        Utils.checkNotNull(employmentType, "employmentType");
        this.employmentType = employmentType;
        return this;
    }

    /**
     * Status of the position
     */
    public Position withStatus(PositionStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * Status of the position
     */
    public Position withStatus(JsonNullable<? extends PositionStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Date when the position was posted
     */
    public Position withPostedDate(OffsetDateTime postedDate) {
        Utils.checkNotNull(postedDate, "postedDate");
        this.postedDate = JsonNullable.of(postedDate);
        return this;
    }

    /**
     * Date when the position was posted
     */
    public Position withPostedDate(JsonNullable<OffsetDateTime> postedDate) {
        Utils.checkNotNull(postedDate, "postedDate");
        this.postedDate = postedDate;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Position other = (Position) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.jobId, other.jobId) &&
            Utils.enhancedDeepEquals(this.title, other.title) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.departmentId, other.departmentId) &&
            Utils.enhancedDeepEquals(this.locationId, other.locationId) &&
            Utils.enhancedDeepEquals(this.employmentType, other.employmentType) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.postedDate, other.postedDate);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, jobId,
            title, description, departmentId,
            locationId, employmentType, status,
            postedDate);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Position.class,
                "id", id,
                "remoteId", remoteId,
                "jobId", jobId,
                "title", title,
                "description", description,
                "departmentId", departmentId,
                "locationId", locationId,
                "employmentType", employmentType,
                "status", status,
                "postedDate", postedDate);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> jobId = JsonNullable.undefined();

        private JsonNullable<String> title = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<String> departmentId = JsonNullable.undefined();

        private JsonNullable<String> locationId = JsonNullable.undefined();

        private JsonNullable<String> employmentType = JsonNullable.undefined();

        private JsonNullable<? extends PositionStatus> status = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> postedDate = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Job ID from the HRIS provider
         */
        public Builder jobId(String jobId) {
            Utils.checkNotNull(jobId, "jobId");
            this.jobId = JsonNullable.of(jobId);
            return this;
        }

        /**
         * Job ID from the HRIS provider
         */
        public Builder jobId(JsonNullable<String> jobId) {
            Utils.checkNotNull(jobId, "jobId");
            this.jobId = jobId;
            return this;
        }


        /**
         * Title of the position
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = JsonNullable.of(title);
            return this;
        }

        /**
         * Title of the position
         */
        public Builder title(JsonNullable<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }


        /**
         * Description of the position
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * Description of the position
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * Department ID associated with the position
         */
        public Builder departmentId(String departmentId) {
            Utils.checkNotNull(departmentId, "departmentId");
            this.departmentId = JsonNullable.of(departmentId);
            return this;
        }

        /**
         * Department ID associated with the position
         */
        public Builder departmentId(JsonNullable<String> departmentId) {
            Utils.checkNotNull(departmentId, "departmentId");
            this.departmentId = departmentId;
            return this;
        }


        /**
         * Location ID associated with the position
         */
        public Builder locationId(String locationId) {
            Utils.checkNotNull(locationId, "locationId");
            this.locationId = JsonNullable.of(locationId);
            return this;
        }

        /**
         * Location ID associated with the position
         */
        public Builder locationId(JsonNullable<String> locationId) {
            Utils.checkNotNull(locationId, "locationId");
            this.locationId = locationId;
            return this;
        }


        /**
         * Employment type for the position
         */
        public Builder employmentType(String employmentType) {
            Utils.checkNotNull(employmentType, "employmentType");
            this.employmentType = JsonNullable.of(employmentType);
            return this;
        }

        /**
         * Employment type for the position
         */
        public Builder employmentType(JsonNullable<String> employmentType) {
            Utils.checkNotNull(employmentType, "employmentType");
            this.employmentType = employmentType;
            return this;
        }


        /**
         * Status of the position
         */
        public Builder status(PositionStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * Status of the position
         */
        public Builder status(JsonNullable<? extends PositionStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * Date when the position was posted
         */
        public Builder postedDate(OffsetDateTime postedDate) {
            Utils.checkNotNull(postedDate, "postedDate");
            this.postedDate = JsonNullable.of(postedDate);
            return this;
        }

        /**
         * Date when the position was posted
         */
        public Builder postedDate(JsonNullable<OffsetDateTime> postedDate) {
            Utils.checkNotNull(postedDate, "postedDate");
            this.postedDate = postedDate;
            return this;
        }

        public Position build() {

            return new Position(
                id, remoteId, jobId,
                title, description, departmentId,
                locationId, employmentType, status,
                postedDate);
        }

    }
}
