/*
 * Decompiled with CFR 0.152.
 */
package com.staffbase.plugins.sdk.sso;

import com.staffbase.plugins.sdk.util.TextUtil;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;

public class SSOData {
    public static final String ROLE_EDITOR = "editor";
    public static final String REMOTE_CALL_DELETE = "delete";
    public static final String KEY_INSTANCE_ID = "instance_id";
    public static final String KEY_USER_ID = "sub";
    public static final String KEY_USER_EXTERNAL_ID = "external_id";
    public static final String KEY_USER_FIRST_NAME = "given_name";
    public static final String KEY_USER_LAST_NAME = "family_name";
    public static final String KEY_USER_ROLE = "role";
    public static final String KEY_USER_LOCALE = "locale";
    public static final String KEY_ISSUER = "iss";
    public static final String KEY_AUDIENCE = "aud";
    public static final String KEY_INSTANCE_NAME = "instance_name";
    public static final String KEY_USER_FULL_NAME = "name";
    public static final String KEY_ENTITY_TYPE = "type";
    public static final String KEY_THEME_TEXT_COLOR = "theming_text";
    public static final String KEY_THEME_BACKGROUND_COLOR = "theming_bg";
    public static final String KEY_TAGS = "tags";
    private final String instanceID;
    private final String userID;
    private final String userExternalID;
    private final String userFirstName;
    private final String userLastName;
    private final String issuer;
    private final String audience;
    private final String instanceName;
    private final String userFullName;
    private final String entityType;
    private final String themeTextColor;
    private final String themeBackgroundColor;
    private final List<String> tags;
    private final String userLocale;
    private final String userRole;

    public SSOData(JwtClaims jwtClaims) throws MalformedClaimException {
        Objects.requireNonNull(jwtClaims);
        this.instanceID = (String)jwtClaims.getClaimValue(KEY_INSTANCE_ID, String.class);
        this.userID = (String)jwtClaims.getClaimValue(KEY_USER_ID, String.class);
        this.userExternalID = (String)jwtClaims.getClaimValue(KEY_USER_EXTERNAL_ID, String.class);
        this.userFirstName = (String)jwtClaims.getClaimValue(KEY_USER_FIRST_NAME, String.class);
        this.userLastName = (String)jwtClaims.getClaimValue(KEY_USER_LAST_NAME, String.class);
        this.userRole = (String)jwtClaims.getClaimValue(KEY_USER_ROLE, String.class);
        this.userLocale = (String)jwtClaims.getClaimValue(KEY_USER_LOCALE, String.class);
        this.issuer = (String)jwtClaims.getClaimValue(KEY_ISSUER, String.class);
        this.audience = (String)jwtClaims.getClaimValue(KEY_AUDIENCE, String.class);
        this.instanceName = (String)jwtClaims.getClaimValue(KEY_INSTANCE_NAME, String.class);
        this.userFullName = (String)jwtClaims.getClaimValue(KEY_USER_FULL_NAME, String.class);
        this.entityType = (String)jwtClaims.getClaimValue(KEY_ENTITY_TYPE, String.class);
        this.themeTextColor = (String)jwtClaims.getClaimValue(KEY_THEME_TEXT_COLOR, String.class);
        this.themeBackgroundColor = (String)jwtClaims.getClaimValue(KEY_THEME_BACKGROUND_COLOR, String.class);
        this.tags = (List)jwtClaims.getClaimValue(KEY_TAGS, List.class);
    }

    public Optional<String> getIssuer() {
        return Optional.ofNullable(this.issuer);
    }

    public Optional<String> getAudience() {
        return Optional.ofNullable(this.audience);
    }

    public Optional<String> getInstanceName() {
        return Optional.ofNullable(this.instanceName);
    }

    public Optional<String> getUserFullName() {
        return Optional.ofNullable(this.userFullName);
    }

    public Optional<String> getEntityType() {
        return Optional.ofNullable(this.entityType);
    }

    public Optional<String> getThemeTextColor() {
        return Optional.ofNullable(this.themeTextColor);
    }

    public Optional<String> getThemeBackgroundColor() {
        return Optional.ofNullable(this.themeBackgroundColor);
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public Optional<String> getUserID() {
        return Optional.ofNullable(this.userID);
    }

    public Optional<String> getUserExternalID() {
        return Optional.ofNullable(this.userExternalID);
    }

    public Optional<String> getUserFirstName() {
        return Optional.ofNullable(this.userFirstName);
    }

    public Optional<String> getUserLastName() {
        return Optional.ofNullable(this.userLastName);
    }

    public Optional<String> getUserLocaleAsString() {
        return Optional.ofNullable(this.userLocale);
    }

    public Optional<Locale> getUserLocale() {
        return TextUtil.parseLocale(this.userLocale);
    }

    public Optional<String> getUserRole() {
        return Optional.ofNullable(this.userRole);
    }

    public boolean isEditor() {
        return ROLE_EDITOR.equals(this.userRole);
    }

    public boolean isDeleteInstanceCall() {
        return REMOTE_CALL_DELETE.equals(this.userID);
    }

    public Optional<List<String>> getTags() {
        return Optional.ofNullable(this.tags);
    }

    public String toString() {
        return "SSOData [ instanceID=" + this.instanceID + ", userID=" + this.userID + ", userExternalID=" + this.userExternalID + ", userFirstName=" + this.userFirstName + ", userLastName=" + this.userLastName + ", userRole=" + this.userRole + ", userLocale=" + this.userLocale + ", issuer=" + this.issuer + ", audience=" + this.audience + ", instanceName=" + this.instanceName + ", userFullName=" + this.userFullName + ", entityType=" + this.entityType + ", themeTextColor=" + this.themeTextColor + ", themeBackgroundColor=" + this.themeBackgroundColor + " ]";
    }
}

