/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.content.Context;
import com.loopj.android.http.AsyncHttpRequest;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.RetryHandler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.SyncBasicHttpContext;

public class AsyncHttpClient {
    private static final String VERSION = "1.4.3";
    private static final int DEFAULT_MAX_CONNECTIONS = 10;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static final int DEFAULT_MAX_RETRIES = 5;
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    private static int maxConnections = 10;
    private static int socketTimeout = 10000;
    private final DefaultHttpClient httpClient;
    private final HttpContext httpContext;
    private ThreadPoolExecutor threadPool;
    private final Map<Context, List<WeakReference<Future<?>>>> requestMap;
    private final Map<String, String> clientHeaderMap;

    public AsyncHttpClient() {
        BasicHttpParams httpParams = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)socketTimeout);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)httpParams, (ConnPerRoute)new ConnPerRouteBean(maxConnections));
        ConnManagerParams.setMaxTotalConnections((HttpParams)httpParams, (int)10);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)socketTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)socketTimeout);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
        HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)httpParams, (String)String.format("android-async-http/%s (http://loopj.com/android-async-http)", VERSION));
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)httpParams, schemeRegistry);
        this.httpContext = new SyncBasicHttpContext((HttpContext)new BasicHttpContext());
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
        this.httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                if (!request.containsHeader(AsyncHttpClient.HEADER_ACCEPT_ENCODING)) {
                    request.addHeader(AsyncHttpClient.HEADER_ACCEPT_ENCODING, AsyncHttpClient.ENCODING_GZIP);
                }
                for (String header : AsyncHttpClient.this.clientHeaderMap.keySet()) {
                    request.addHeader(header, (String)AsyncHttpClient.this.clientHeaderMap.get(header));
                }
            }
        });
        this.httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return;
                }
                Header encoding = entity.getContentEncoding();
                if (encoding != null) {
                    for (HeaderElement element : encoding.getElements()) {
                        if (!element.getName().equalsIgnoreCase(AsyncHttpClient.ENCODING_GZIP)) continue;
                        response.setEntity((HttpEntity)new InflatingEntity(response.getEntity()));
                        break;
                    }
                }
            }
        });
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(5));
        this.threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.requestMap = new WeakHashMap();
        this.clientHeaderMap = new HashMap<String, String>();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
    }

    public void setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
    }

    public void setUserAgent(String userAgent) {
        HttpProtocolParams.setUserAgent((HttpParams)this.httpClient.getParams(), (String)userAgent);
    }

    public void setTimeout(int timeout) {
        HttpParams httpParams = this.httpClient.getParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeout);
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)sslSocketFactory, 443));
    }

    public void addHeader(String header, String value) {
        this.clientHeaderMap.put(header, value);
    }

    public void setBasicAuth(String user, String pass) {
        AuthScope scope = AuthScope.ANY;
        this.setBasicAuth(user, pass, scope);
    }

    public void setBasicAuth(String user, String pass, AuthScope scope) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, pass);
        this.httpClient.getCredentialsProvider().setCredentials(scope, (Credentials)credentials);
    }

    public void cancelRequests(Context context, boolean mayInterruptIfRunning) {
        List<WeakReference<Future<?>>> requestList = this.requestMap.get(context);
        if (requestList != null) {
            for (WeakReference<Future<?>> requestRef : requestList) {
                Future request = (Future)requestRef.get();
                if (request == null) continue;
                request.cancel(mayInterruptIfRunning);
            }
        }
        this.requestMap.remove(context);
    }

    public void get(String url, AsyncHttpResponseHandler responseHandler) {
        this.get(null, url, null, responseHandler);
    }

    public void get(String url, RequestParams params, AsyncHttpResponseHandler responseHandler) {
        this.get(null, url, params, responseHandler);
    }

    public void get(Context context, String url, AsyncHttpResponseHandler responseHandler) {
        this.get(context, url, null, responseHandler);
    }

    public void get(Context context, String url, RequestParams params, AsyncHttpResponseHandler responseHandler) {
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)new HttpGet(AsyncHttpClient.getUrlWithQueryString(url, params)), null, responseHandler, context);
    }

    public void get(Context context, String url, Header[] headers, RequestParams params, AsyncHttpResponseHandler responseHandler) {
        HttpGet request = new HttpGet(AsyncHttpClient.getUrlWithQueryString(url, params));
        if (headers != null) {
            request.setHeaders(headers);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, null, responseHandler, context);
    }

    public void post(String url, AsyncHttpResponseHandler responseHandler) {
        this.post(null, url, null, responseHandler);
    }

    public void post(String url, RequestParams params, AsyncHttpResponseHandler responseHandler) {
        this.post(null, url, params, responseHandler);
    }

    public void post(Context context, String url, RequestParams params, AsyncHttpResponseHandler responseHandler) {
        this.post(context, url, this.paramsToEntity(params), null, responseHandler);
    }

    public void post(Context context, String url, HttpEntity entity, String contentType, AsyncHttpResponseHandler responseHandler) {
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(url), entity), contentType, responseHandler, context);
    }

    public void post(Context context, String url, Header[] headers, RequestParams params, String contentType, AsyncHttpResponseHandler responseHandler) {
        HttpPost request = new HttpPost(url);
        if (params != null) {
            request.setEntity(this.paramsToEntity(params));
        }
        if (headers != null) {
            request.setHeaders(headers);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, contentType, responseHandler, context);
    }

    public void post(Context context, String url, Header[] headers, HttpEntity entity, String contentType, AsyncHttpResponseHandler responseHandler) {
        HttpEntityEnclosingRequestBase request = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(url), entity);
        if (headers != null) {
            request.setHeaders(headers);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, contentType, responseHandler, context);
    }

    public void put(String url, AsyncHttpResponseHandler responseHandler) {
        this.put(null, url, null, responseHandler);
    }

    public void put(String url, RequestParams params, AsyncHttpResponseHandler responseHandler) {
        this.put(null, url, params, responseHandler);
    }

    public void put(Context context, String url, RequestParams params, AsyncHttpResponseHandler responseHandler) {
        this.put(context, url, this.paramsToEntity(params), null, responseHandler);
    }

    public void put(Context context, String url, HttpEntity entity, String contentType, AsyncHttpResponseHandler responseHandler) {
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(url), entity), contentType, responseHandler, context);
    }

    public void put(Context context, String url, Header[] headers, HttpEntity entity, String contentType, AsyncHttpResponseHandler responseHandler) {
        HttpEntityEnclosingRequestBase request = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(url), entity);
        if (headers != null) {
            request.setHeaders(headers);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, contentType, responseHandler, context);
    }

    public void delete(String url, AsyncHttpResponseHandler responseHandler) {
        this.delete(null, url, responseHandler);
    }

    public void delete(Context context, String url, AsyncHttpResponseHandler responseHandler) {
        HttpDelete delete = new HttpDelete(url);
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)delete, null, responseHandler, context);
    }

    public void delete(Context context, String url, Header[] headers, AsyncHttpResponseHandler responseHandler) {
        HttpDelete delete = new HttpDelete(url);
        if (headers != null) {
            delete.setHeaders(headers);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)delete, null, responseHandler, context);
    }

    protected void sendRequest(DefaultHttpClient client, HttpContext httpContext, HttpUriRequest uriRequest, String contentType, AsyncHttpResponseHandler responseHandler, Context context) {
        if (contentType != null) {
            uriRequest.addHeader("Content-Type", contentType);
        }
        Future<?> request = this.threadPool.submit(new AsyncHttpRequest((AbstractHttpClient)client, httpContext, uriRequest, responseHandler));
        if (context != null) {
            List<WeakReference<Future<?>>> requestList = this.requestMap.get(context);
            if (requestList == null) {
                requestList = new LinkedList();
                this.requestMap.put(context, requestList);
            }
            requestList.add(new WeakReference(request));
        }
    }

    public static String getUrlWithQueryString(String url, RequestParams params) {
        if (params != null) {
            String paramString = params.getParamString();
            url = url.indexOf("?") == -1 ? url + "?" + paramString : url + "&" + paramString;
        }
        return url;
    }

    private HttpEntity paramsToEntity(RequestParams params) {
        HttpEntity entity = null;
        if (params != null) {
            entity = params.getEntity();
        }
        return entity;
    }

    private HttpEntityEnclosingRequestBase addEntityToRequestBase(HttpEntityEnclosingRequestBase requestBase, HttpEntity entity) {
        if (entity != null) {
            requestBase.setEntity(entity);
        }
        return requestBase;
    }

    private static class InflatingEntity
    extends HttpEntityWrapper {
        public InflatingEntity(HttpEntity wrapped) {
            super(wrapped);
        }

        public InputStream getContent() throws IOException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

