/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.AttachmentManager;
import com.taskadapter.redmineapi.IssueManager;
import com.taskadapter.redmineapi.MembershipManager;
import com.taskadapter.redmineapi.ProjectManager;
import com.taskadapter.redmineapi.UserManager;
import com.taskadapter.redmineapi.WikiManager;
import com.taskadapter.redmineapi.internal.Transport;

public class RedmineManager {
    private final Transport transport;
    private final Runnable shutdownListener;
    private final IssueManager issueManager;
    private final AttachmentManager attachmentManager;
    private final UserManager userManager;
    private final ProjectManager projectManager;
    private final MembershipManager membershipManager;
    private final WikiManager wikiManager;

    RedmineManager(Transport transport, Runnable shutdownListener) {
        this.transport = transport;
        this.issueManager = new IssueManager(transport);
        this.attachmentManager = new AttachmentManager(transport);
        this.userManager = new UserManager(transport);
        this.projectManager = new ProjectManager(transport);
        this.membershipManager = new MembershipManager(transport);
        this.wikiManager = new WikiManager(transport);
        this.shutdownListener = shutdownListener;
    }

    public WikiManager getWikiManager() {
        return this.wikiManager;
    }

    public IssueManager getIssueManager() {
        return this.issueManager;
    }

    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    public int getObjectsPerPage() {
        return this.transport.getObjectsPerPage();
    }

    public void setObjectsPerPage(int pageSize) {
        this.transport.setObjectsPerPage(pageSize);
    }

    public void shutdown() {
        if (this.shutdownListener != null) {
            this.shutdownListener.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.shutdown();
        }
    }
}

