/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Membership;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class User
implements Identifiable {
    public static final Integer STATUS_LOCKED = 3;
    public static final Integer STATUS_ACTIVE = 1;
    private final Integer id;
    private String login;
    private String password;
    private String firstName;
    private String lastName;
    private String mail;
    private Date createdOn;
    private Date lastLoginOn;
    private String apiKey;
    private Integer authSourceId;
    private Integer status;
    private final Set<CustomField> customFields = new HashSet<CustomField>();
    private final Set<Membership> memberships = new HashSet<Membership>();
    private final Set<Group> groups = new HashSet<Group>();

    User(Integer id) {
        this.id = id;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public String toString() {
        return this.getFullName();
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getLastLoginOn() {
        return this.lastLoginOn;
    }

    public void setLastLoginOn(Date lastLoginOn) {
        this.lastLoginOn = lastLoginOn;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    @Deprecated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Deprecated
    public Integer getAuthSourceId() {
        return this.authSourceId;
    }

    public void setAuthSourceId(Integer authSource) {
        this.authSourceId = authSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return !(this.id != null ? !this.id.equals(user.id) : user.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String getFullName() {
        return this.firstName + " " + this.lastName;
    }

    public void setFullName(String fullName) {
        int ind = fullName.indexOf(32);
        if (ind != -1) {
            this.firstName = fullName.substring(0, ind);
            this.lastName = fullName.substring(ind + 1);
        } else {
            this.firstName = fullName;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCustomField(String fieldName) {
        for (CustomField f : this.customFields) {
            if (!f.getName().equals(fieldName)) continue;
            return f.getValue();
        }
        return null;
    }

    public Collection<CustomField> getCustomFields() {
        return Collections.unmodifiableCollection(this.customFields);
    }

    public void clearCustomFields() {
        this.customFields.clear();
    }

    public void addCustomFields(Collection<CustomField> customFields) {
        this.customFields.addAll(customFields);
    }

    public void addCustomField(CustomField customField) {
        this.customFields.add(customField);
    }

    public Collection<Membership> getMemberships() {
        return Collections.unmodifiableCollection(this.memberships);
    }

    public void addMemberships(Collection<Membership> memberships) {
        this.memberships.addAll(memberships);
    }

    public Collection<Group> getGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    public void addGroups(Collection<Group> groups) {
        this.groups.addAll(groups);
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}

