/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.NotFoundException;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.MembershipFactory;
import com.taskadapter.redmineapi.bean.News;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.ProjectFactory;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ProjectManager {
    private final Transport transport;

    ProjectManager(Transport transport) {
        this.transport = transport;
    }

    public Project createProject(Project project) throws RedmineException {
        return this.transport.addObject(project, new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
    }

    public List<Project> getProjects() throws RedmineException {
        try {
            return this.transport.getObjectsList(Project.class, new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
        }
        catch (NotFoundException e) {
            throw new RedmineInternalError("NotFoundException received, which should never happen in this request");
        }
    }

    public Project getProjectByKey(String projectKey) throws RedmineException {
        return this.transport.getObject(Project.class, projectKey, new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
    }

    public Project getProjectById(int id) throws RedmineException {
        return this.transport.getObject(Project.class, id, new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
    }

    public void deleteProject(String projectKey) throws RedmineException {
        this.transport.deleteObject(Project.class, projectKey);
    }

    public Version createVersion(Version version) throws RedmineException {
        if (version.getProjectId() == null) {
            throw new IllegalArgumentException("Version must contain projectId");
        }
        return this.transport.addChildEntry(Project.class, version.getProjectId().toString(), version, new NameValuePair[0]);
    }

    public void deleteVersion(Version version) throws RedmineException {
        this.transport.deleteObject(Version.class, Integer.toString(version.getId()));
    }

    public List<Version> getVersions(int projectID) throws RedmineException {
        return this.transport.getChildEntries(Project.class, Integer.toString(projectID), Version.class);
    }

    public Version getVersionById(int versionId) throws RedmineException {
        return this.transport.getObject(Version.class, versionId, new NameValuePair[0]);
    }

    public void update(Project object) throws RedmineException {
        this.transport.updateObject(object, new NameValuePair[0]);
    }

    public void update(Version object) throws RedmineException {
        this.transport.updateObject(object, new NameValuePair[0]);
    }

    public List<News> getNews(String projectKey) throws RedmineException {
        HashSet<BasicNameValuePair> params = new HashSet<BasicNameValuePair>();
        if (projectKey != null && projectKey.length() > 0) {
            params.add(new BasicNameValuePair("project_id", projectKey));
        }
        return this.transport.getObjectsList(News.class, params);
    }

    public Membership addUserToProject(int projectId, int userId, Collection<Role> roles) throws RedmineException {
        Membership membership = MembershipFactory.create();
        Project project = ProjectFactory.create(projectId);
        membership.setProject(project);
        membership.setUserId(userId);
        membership.addRoles(roles);
        return this.addMembership(membership);
    }

    public Membership addGroupToProject(int projectId, int groupId, Collection<Role> roles) throws RedmineException {
        Membership membership = MembershipFactory.create();
        Project project = ProjectFactory.create(projectId);
        membership.setProject(project);
        membership.setUserId(groupId);
        membership.addRoles(roles);
        return this.addMembership(membership);
    }

    public List<Membership> getProjectMembers(String projectKey) throws RedmineException {
        return this.transport.getChildEntries(Project.class, projectKey, Membership.class);
    }

    public List<Membership> getProjectMembers(int projectId) throws RedmineException {
        return this.transport.getChildEntries(Project.class, projectId, Membership.class);
    }

    public Membership getProjectMember(int membershipId) throws RedmineException {
        return this.transport.getObject(Membership.class, membershipId, new NameValuePair[0]);
    }

    public void deleteProjectMembership(int membershipId) throws RedmineException {
        this.transport.deleteObject(Membership.class, Integer.toString(membershipId));
    }

    public void deleteProjectMembership(Membership membership) throws RedmineException {
        this.transport.deleteObject(Membership.class, membership.getId().toString());
    }

    public void updateProjectMembership(Membership membership) throws RedmineException {
        this.transport.updateObject(membership, new NameValuePair[0]);
    }

    private Membership addMembership(Membership membership) throws RedmineException {
        Project project = membership.getProject();
        if (project == null) {
            throw new IllegalArgumentException("Project must be set");
        }
        if (membership.getUserId() == null && membership.getRoles().isEmpty()) {
            throw new IllegalArgumentException("Either User or Roles field must be set");
        }
        return this.transport.addChildEntry(Project.class, project.getId() + "", membership, new NameValuePair[0]);
    }
}

