/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.AttachmentManager;
import com.taskadapter.redmineapi.CustomFieldManager;
import com.taskadapter.redmineapi.IssueManager;
import com.taskadapter.redmineapi.MembershipManager;
import com.taskadapter.redmineapi.ProjectManager;
import com.taskadapter.redmineapi.TimeEntryManager;
import com.taskadapter.redmineapi.UserManager;
import com.taskadapter.redmineapi.WikiManager;
import com.taskadapter.redmineapi.internal.Transport;

public class RedmineManager {
    private final Transport transport;
    private final IssueManager issueManager;
    private final AttachmentManager attachmentManager;
    private final UserManager userManager;
    private final ProjectManager projectManager;
    private final MembershipManager membershipManager;
    private final CustomFieldManager customFieldManager;
    private final WikiManager wikiManager;
    private final TimeEntryManager timeEntryManager;

    RedmineManager(Transport transport) {
        this.transport = transport;
        this.issueManager = new IssueManager(transport);
        this.attachmentManager = new AttachmentManager(transport);
        this.userManager = new UserManager(transport);
        this.projectManager = new ProjectManager(transport);
        this.membershipManager = new MembershipManager(transport);
        this.wikiManager = new WikiManager(transport);
        this.customFieldManager = new CustomFieldManager(transport);
        this.timeEntryManager = new TimeEntryManager(transport);
    }

    public WikiManager getWikiManager() {
        return this.wikiManager;
    }

    public IssueManager getIssueManager() {
        return this.issueManager;
    }

    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    @Deprecated
    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    public CustomFieldManager getCustomFieldManager() {
        return this.customFieldManager;
    }

    public TimeEntryManager getTimeEntryManager() {
        return this.timeEntryManager;
    }

    public void setObjectsPerPage(int pageSize) {
        this.transport.setObjectsPerPage(pageSize);
    }

    public void setOnBehalfOfUser(String loginName) {
        this.transport.setOnBehalfOfUser(loginName);
    }
}

