/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import com.taskadapter.redmineapi.bean.Role;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Membership
implements Identifiable {
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> DATABASE_ID = new Property<Integer>(Integer.class, "id");
    public static final Property<Project> PROJECT = new Property<Project>(Project.class, "project");
    public static final Property<Integer> USER_ID = new Property<Integer>(Integer.class, "userId");
    public static final Property<String> USER_NAME = new Property<String>(String.class, "userName");
    public static final Property<Integer> GROUP_ID = new Property<Integer>(Integer.class, "groupId");
    public static final Property<String> GROUP_NAME = new Property<String>(String.class, "groupName");
    public static final Property<Set<Role>> ROLES = new Property<Set>(Set.class, "roles");

    Membership(Integer id) {
        this.storage.set(ROLES, new HashSet());
        this.storage.set(DATABASE_ID, id);
    }

    @Override
    public Integer getId() {
        return this.storage.get(DATABASE_ID);
    }

    public Project getProject() {
        return this.storage.get(PROJECT);
    }

    public void setProject(Project project) {
        this.storage.set(PROJECT, project);
    }

    public Integer getUserId() {
        return this.storage.get(USER_ID);
    }

    public void setUserId(Integer id) {
        this.storage.set(USER_ID, id);
    }

    public Integer getGroupId() {
        return this.storage.get(GROUP_ID);
    }

    public void setGroupId(Integer id) {
        this.storage.set(GROUP_ID, id);
    }

    public String getUserName() {
        return this.storage.get(USER_NAME);
    }

    public void setUserName(String id) {
        this.storage.set(USER_NAME, id);
    }

    public String getGroupName() {
        return this.storage.get(GROUP_NAME);
    }

    public void setGroupName(String id) {
        this.storage.set(GROUP_NAME, id);
    }

    public Collection<Role> getRoles() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(ROLES));
    }

    public void addRoles(Collection<Role> roles) {
        this.storage.get(ROLES).addAll(roles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Membership that = (Membership)o;
        return !(this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null);
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public String toString() {
        return "Membership [id=" + this.getId() + ", project=" + this.getProject() + ", userId=" + this.getUserId() + ", groupId=" + this.getGroupId() + ", roles=" + this.getRoles() + "]";
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }
}

