/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import com.taskadapter.redmineapi.bean.Tracker;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Project
implements Identifiable,
Serializable {
    private static final long serialVersionUID = 4529305420978716446L;
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> DATABASE_ID = new Property<Integer>(Integer.class, "id");
    public static final Property<String> STRING_IDENTIFIER = new Property<String>(String.class, "identifier");
    public static final Property<String> NAME = new Property<String>(String.class, "name");
    public static final Property<String> DESCRIPTION = new Property<String>(String.class, "description");
    public static final Property<String> HOMEPAGE = new Property<String>(String.class, "homepage");
    public static final Property<Date> CREATED_ON = new Property<Date>(Date.class, "createdOn");
    public static final Property<Date> UPDATED_ON = new Property<Date>(Date.class, "updatedOn");
    public static final Property<Integer> PARENT_DATABASE_ID = new Property<Integer>(Integer.class, "parentId");
    public static final Property<Boolean> PUBLIC = new Property<Boolean>(Boolean.class, "public");
    public static final Property<Boolean> INHERIT_MEMBERS = new Property<Boolean>(Boolean.class, "inheritMembers");
    public static final Property<Set<CustomField>> CUSTOM_FIELDS = new Property<Set>(Set.class, "customFields");
    public static final Property<Set<Tracker>> TRACKERS = new Property<Set>(Set.class, "trackers");

    Project(Integer id) {
        this.storage.set(DATABASE_ID, id);
        this.storage.set(CUSTOM_FIELDS, new HashSet());
        this.storage.set(TRACKERS, new HashSet());
    }

    public String getHomepage() {
        return this.storage.get(HOMEPAGE);
    }

    public void setHomepage(String homepage) {
        this.storage.set(HOMEPAGE, homepage);
    }

    public String getIdentifier() {
        return this.storage.get(STRING_IDENTIFIER);
    }

    public void setIdentifier(String identifier) {
        this.storage.set(STRING_IDENTIFIER, identifier);
    }

    @Override
    public Integer getId() {
        return this.storage.get(DATABASE_ID);
    }

    public String getName() {
        return this.storage.get(NAME);
    }

    public void setName(String name) {
        this.storage.set(NAME, name);
    }

    public Collection<Tracker> getTrackers() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(TRACKERS));
    }

    public void addTrackers(Collection<Tracker> trackers) {
        this.storage.get(TRACKERS).addAll(trackers);
    }

    public Tracker getTrackerByName(String trackerName) {
        for (Tracker t : this.getTrackers()) {
            if (!t.getName().equals(trackerName)) continue;
            return t;
        }
        return null;
    }

    public String toString() {
        return "Project{id=" + this.getId() + ", identifier='" + this.getIdentifier() + '\'' + ", name='" + this.getName() + '\'' + '}';
    }

    public String getDescription() {
        return this.storage.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.storage.set(DESCRIPTION, description);
    }

    public Date getCreatedOn() {
        return this.storage.get(CREATED_ON);
    }

    public void setCreatedOn(Date createdOn) {
        this.storage.set(CREATED_ON, createdOn);
    }

    public Date getUpdatedOn() {
        return this.storage.get(UPDATED_ON);
    }

    public void setUpdatedOn(Date updatedOn) {
        this.storage.set(UPDATED_ON, updatedOn);
    }

    public Integer getParentId() {
        return this.storage.get(PARENT_DATABASE_ID);
    }

    public void setParentId(Integer parentId) {
        this.storage.set(PARENT_DATABASE_ID, parentId);
    }

    @Deprecated
    public Boolean getProjectPublic() {
        return this.storage.get(PUBLIC);
    }

    public void setInheritMembers(Boolean inheritMembers) {
        this.storage.set(INHERIT_MEMBERS, inheritMembers);
    }

    public Boolean getInheritMembers() {
        return this.storage.get(INHERIT_MEMBERS);
    }

    public void setProjectPublic(Boolean projectPublic) {
        this.storage.set(PUBLIC, projectPublic);
    }

    public Collection<CustomField> getCustomFields() {
        return this.storage.get(CUSTOM_FIELDS);
    }

    public void addCustomFields(Collection<CustomField> customFields) {
        this.storage.get(CUSTOM_FIELDS).addAll(customFields);
    }

    public CustomField getCustomFieldById(int customFieldId) {
        for (CustomField customField : this.getCustomFields()) {
            if (customFieldId != customField.getId()) continue;
            return customField;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return !(this.getId() != null ? !this.getId().equals(project.getId()) : project.getId() != null);
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }
}

