/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TimeEntry
implements Identifiable {
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> DATABASE_ID = new Property<Integer>(Integer.class, "id");
    public static final Property<Integer> ISSUE_ID = new Property<Integer>(Integer.class, "issueId");
    public static final Property<Integer> PROJECT_ID = new Property<Integer>(Integer.class, "projectId");
    public static final Property<String> PROJECT_NAME = new Property<String>(String.class, "projectName");
    public static final Property<String> USER_NAME = new Property<String>(String.class, "userName");
    public static final Property<Integer> USER_ID = new Property<Integer>(Integer.class, "userId");
    public static final Property<String> ACTIVITY_NAME = new Property<String>(String.class, "activityName");
    public static final Property<Integer> ACTIVITY_ID = new Property<Integer>(Integer.class, "activityId");
    public static final Property<Float> HOURS = new Property<Float>(Float.class, "hours");
    public static final Property<String> COMMENT = new Property<String>(String.class, "comment");
    public static final Property<Date> SPENT_ON = new Property<Date>(Date.class, "spentOn");
    public static final Property<Date> CREATED_ON = new Property<Date>(Date.class, "createdOn");
    public static final Property<Date> UPDATED_ON = new Property<Date>(Date.class, "updatedOn");
    public static final Property<Set<CustomField>> CUSTOM_FIELDS = new Property<Set>(Set.class, "custom_fields");

    TimeEntry(Integer id) {
        this.storage.set(DATABASE_ID, id);
        this.storage.set(CUSTOM_FIELDS, new HashSet());
    }

    @Override
    public Integer getId() {
        return this.storage.get(DATABASE_ID);
    }

    public Integer getUserId() {
        return this.storage.get(USER_ID);
    }

    public void setUserId(Integer userId) {
        this.storage.set(USER_ID, userId);
    }

    public Integer getIssueId() {
        return this.storage.get(ISSUE_ID);
    }

    public void setIssueId(Integer issueId) {
        this.storage.set(ISSUE_ID, issueId);
    }

    public Integer getProjectId() {
        return this.storage.get(PROJECT_ID);
    }

    public void setProjectId(Integer projectId) {
        this.storage.set(PROJECT_ID, projectId);
    }

    public String getProjectName() {
        return this.storage.get(PROJECT_NAME);
    }

    public void setProjectName(String projectName) {
        this.storage.set(PROJECT_NAME, projectName);
    }

    public String getActivityName() {
        return this.storage.get(ACTIVITY_NAME);
    }

    public void setActivityName(String activityName) {
        this.storage.set(ACTIVITY_NAME, activityName);
    }

    public Integer getActivityId() {
        return this.storage.get(ACTIVITY_ID);
    }

    public void setActivityId(Integer activityId) {
        this.storage.set(ACTIVITY_ID, activityId);
    }

    public Float getHours() {
        return this.storage.get(HOURS);
    }

    public void setHours(Float hours) {
        this.storage.set(HOURS, hours);
    }

    public String getComment() {
        return this.storage.get(COMMENT);
    }

    public void setComment(String comment) {
        this.storage.set(COMMENT, comment);
    }

    public Date getSpentOn() {
        return this.storage.get(SPENT_ON);
    }

    public void setSpentOn(Date spentOn) {
        this.storage.set(SPENT_ON, spentOn);
    }

    public Date getCreatedOn() {
        return this.storage.get(CREATED_ON);
    }

    public void setCreatedOn(Date createdOn) {
        this.storage.set(CREATED_ON, createdOn);
    }

    public Date getUpdatedOn() {
        return this.storage.get(UPDATED_ON);
    }

    public void setUpdatedOn(Date updatedOn) {
        this.storage.set(UPDATED_ON, updatedOn);
    }

    public String getUserName() {
        return this.storage.get(USER_NAME);
    }

    public void setUserName(String userName) {
        this.storage.set(USER_NAME, userName);
    }

    public CustomField getCustomField(String name) {
        return this.storage.get(CUSTOM_FIELDS).stream().filter(a -> a.getName().equals(name)).findFirst().orElse(null);
    }

    public String toString() {
        return "User \"" + this.getUserName() + "\" spent " + this.getHours() + " hours on task " + this.getIssueId() + " (project \"" + this.getProjectName() + "\") doing " + this.getActivityName();
    }

    public Set<CustomField> getCustomFields() {
        return this.storage.get(CUSTOM_FIELDS);
    }

    public void clearCustomFields() {
        this.storage.set(CUSTOM_FIELDS, new HashSet());
    }

    public void addCustomFields(Collection<CustomField> customFields) {
        this.storage.get(CUSTOM_FIELDS).addAll(customFields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeEntry timeEntry = (TimeEntry)o;
        return !(this.getId() != null ? !this.getId().equals(timeEntry.getId()) : timeEntry.getId() != null);
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public boolean isValid() {
        return this.getHours() != null && (this.getProjectId() != null || this.getIssueId() != null);
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }
}

