/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.impl.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.julienvey.trello.NotAuthorizedException;
import com.julienvey.trello.NotFoundException;
import com.julienvey.trello.TrelloBadRequestException;
import com.julienvey.trello.TrelloHttpClient;
import com.julienvey.trello.exception.TrelloHttpException;
import com.julienvey.trello.impl.http.UrlExpander;
import com.julienvey.trello.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;

public class ApacheHttpClient
implements TrelloHttpClient {
    private DefaultHttpClient httpClient;
    private ObjectMapper mapper;

    public ApacheHttpClient() {
        this(new DefaultHttpClient());
    }

    public ApacheHttpClient(DefaultHttpClient httpClient) {
        this.httpClient = httpClient;
        this.mapper = new ObjectMapper();
    }

    @Override
    public <T> T get(String url, Class<T> responseType, String ... params) {
        HttpGet httpGet = new HttpGet(UrlExpander.expandUrl(url, params));
        return this.getEntityAndReleaseConnection(responseType, (HttpRequestBase)httpGet);
    }

    @Override
    public <T> T postForObject(String url, Object body, Class<T> responseType, String ... params) {
        HttpPost httpPost = new HttpPost(UrlExpander.expandUrl(url, params));
        try {
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper.writeValueAsBytes(body), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            return this.getEntityAndReleaseConnection(responseType, (HttpRequestBase)httpPost);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T postFileForObject(String url, File file, Class<T> objectClass, String ... params) {
        HttpPost httpPost = new HttpPost(UrlExpander.expandUrl(url, params));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("file", (ContentBody)new FileBody(file));
        try {
            entity.addPart("filename", (ContentBody)new StringBody(file.getName()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        httpPost.setEntity((HttpEntity)entity);
        return this.getEntityAndReleaseConnection(objectClass, (HttpRequestBase)httpPost);
    }

    @Override
    public <T> T putForObject(String url, Object body, Class<T> responseType, String ... params) {
        HttpPut put = new HttpPut(UrlExpander.expandUrl(url, params));
        try {
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper.writeValueAsBytes(body), ContentType.APPLICATION_JSON);
            put.setEntity((HttpEntity)entity);
            return this.getEntityAndReleaseConnection(responseType, (HttpRequestBase)put);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T delete(String url, Class<T> responseType, String ... params) {
        return this.getEntityAndReleaseConnection(responseType, (HttpRequestBase)new HttpDelete(UrlExpander.expandUrl(url, params)));
    }

    @Override
    public URI postForLocation(String url, Object body, String ... params) {
        HttpPost httpPost = new HttpPost(UrlExpander.expandUrl(url, params));
        try {
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper.writeValueAsBytes(body), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            Header location = httpResponse.getFirstHeader("Location");
            if (location != null) {
                URI uRI = URI.create(location.getValue());
                return uRI;
            }
            try {
                throw new NullPointerException();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new TrelloHttpException(e);
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T getEntityAndReleaseConnection(Class<T> objectClass, HttpRequestBase httpRequest) {
        try {
            Object object;
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) throw new TrelloHttpException("http entity returned by Trello is null");
            String body = IOUtils.toString(httpEntity.getContent());
            if (httpResponse.getStatusLine().getStatusCode() == 400) {
                throw new TrelloBadRequestException(body);
            }
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new NotAuthorizedException(body);
            }
            if (httpResponse.getStatusLine().getStatusCode() == 404) {
                throw new NotFoundException("Resource not found: " + httpRequest.getURI());
            }
            try {
                object = this.mapper.readValue(body, objectClass);
            }
            catch (JsonProcessingException e) {
                try {
                    throw new TrelloHttpException("Cannot parse Trello response. Expected to get a json string, but got: " + body);
                }
                catch (TrelloHttpException e2) {
                    throw e2;
                }
                catch (IOException e3) {
                    throw new TrelloHttpException(e3);
                }
            }
            return (T)object;
        }
        finally {
            httpRequest.releaseConnection();
        }
    }
}

