/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.impl;

import com.julienvey.trello.ListNotFoundException;
import com.julienvey.trello.NotFoundException;
import com.julienvey.trello.Trello;
import com.julienvey.trello.TrelloBadRequestException;
import com.julienvey.trello.TrelloHttpClient;
import com.julienvey.trello.domain.Action;
import com.julienvey.trello.domain.AddMemberToBoardResult;
import com.julienvey.trello.domain.Argument;
import com.julienvey.trello.domain.Attachment;
import com.julienvey.trello.domain.Board;
import com.julienvey.trello.domain.Card;
import com.julienvey.trello.domain.CardWithActions;
import com.julienvey.trello.domain.CheckItem;
import com.julienvey.trello.domain.CheckList;
import com.julienvey.trello.domain.Entity;
import com.julienvey.trello.domain.Label;
import com.julienvey.trello.domain.Member;
import com.julienvey.trello.domain.MemberType;
import com.julienvey.trello.domain.MyPrefs;
import com.julienvey.trello.domain.Organization;
import com.julienvey.trello.domain.TList;
import com.julienvey.trello.domain.TrelloEntity;
import com.julienvey.trello.impl.TrelloUrl;
import com.julienvey.trello.impl.domaininternal.Comment;
import com.julienvey.trello.impl.http.JDKTrelloHttpClient;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrelloImpl
implements Trello {
    private TrelloHttpClient httpClient;
    private String applicationKey;
    private String accessToken;
    private static Logger logger = LoggerFactory.getLogger(TrelloImpl.class);

    @Deprecated
    public TrelloImpl(String applicationKey, String accessToken) {
        this(applicationKey, accessToken, new JDKTrelloHttpClient());
    }

    public TrelloImpl(String applicationKey, String accessToken, TrelloHttpClient httpClient) {
        this.applicationKey = applicationKey;
        this.accessToken = accessToken;
        this.httpClient = httpClient;
    }

    @Override
    public Board getBoard(String boardId, Argument ... args) {
        Board board = this.get(TrelloUrl.createUrl("/boards/{boardId}?").params(args).asString(), Board.class, boardId);
        board.setInternalTrello(this);
        return board;
    }

    @Override
    public List<Action> getBoardActions(String boardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/boards/{boardId}/actions?").params(args).asString(), Action[].class, boardId));
    }

    @Override
    public List<Card> getBoardCards(String boardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/boards/{boardId}/cards?").params(args).asString(), Card[].class, boardId));
    }

    @Override
    public Card getBoardCard(String boardId, String cardId, Argument ... args) {
        Card card = this.get(TrelloUrl.createUrl("/boards/{boardId}/cards/{cardId}?").params(args).asString(), Card.class, boardId, cardId);
        card.setInternalTrello(this);
        return card;
    }

    @Override
    public List<CheckList> getBoardChecklists(String boardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/boards/{boardId}/checklists?").params(args).asString(), CheckList[].class, boardId));
    }

    @Override
    public List<Label> getBoardLabels(String boardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/boards/{boardId}/labels?").params(args).asString(), Label[].class, boardId));
    }

    @Override
    public List<TList> getBoardLists(String boardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/boards/{boardId}/lists?").params(args).asString(), TList[].class, boardId));
    }

    @Override
    public List<Member> getBoardMembers(String boardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/boards/{boardId}/members?").params(args).asString(), Member[].class, boardId));
    }

    @Override
    public List<Card> getBoardMemberCards(String boardId, String memberId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/boards/{boardId}/members/{memberId}/cards?").params(args).asString(), Card[].class, boardId, memberId));
    }

    @Override
    public AddMemberToBoardResult addMemberToBoard(String boardId, String email, MemberType type, String fullName) {
        Objects.requireNonNull(boardId);
        Objects.requireNonNull(email);
        HashMap<String, String> body = new HashMap<String, String>(3);
        body.put("fullName", fullName);
        body.put("email", email);
        body.put("type", Optional.ofNullable(type).orElse(MemberType.NORMAL).value());
        AddMemberToBoardResult result = this.put(TrelloUrl.createUrl("/boards/{boardId}/members?").asString(), body, AddMemberToBoardResult.class, boardId);
        result.setInternalTrello(this);
        return result;
    }

    @Override
    public AddMemberToBoardResult addMemberToBoard(String boardId, String memberId, MemberType type) {
        Objects.requireNonNull(boardId);
        Objects.requireNonNull(memberId);
        Map<String, String> body = Collections.singletonMap("type", Optional.ofNullable(type).orElse(MemberType.NORMAL).value());
        AddMemberToBoardResult result = this.put(TrelloUrl.createUrl("/boards/{boardId}/members/{memberId}?").asString(), body, AddMemberToBoardResult.class, boardId, memberId);
        result.setInternalTrello(this);
        return result;
    }

    @Override
    public Board removeMemberFromBoard(String boardId, String memberId) {
        Objects.requireNonNull(boardId);
        Objects.requireNonNull(memberId);
        try {
            Board board = this.delete(TrelloUrl.createUrl("/boards/{boardId}/members/{memberId}?").asString(), Board.class, boardId, memberId);
            board.setInternalTrello(this);
            return board;
        }
        catch (TrelloBadRequestException e) {
            if ("membership not found".equalsIgnoreCase(e.getMessage())) {
                throw new NotFoundException(String.format("User with member id %s is not member of %s board.", memberId, boardId));
            }
            if ("Invalid id or name".equalsIgnoreCase(e.getMessage())) {
                throw new NotFoundException(String.format("User with memberId or username %s is not found.", memberId));
            }
            throw e;
        }
    }

    @Override
    @Deprecated
    public List<CardWithActions> getBoardMemberActivity(String boardId, String memberId, String actionFilter, Argument ... args) {
        if (actionFilter == null) {
            actionFilter = "all";
        }
        Argument[] argsAndFilter = Arrays.copyOf(args, args.length + 1);
        argsAndFilter[args.length] = new Argument("actions", actionFilter);
        return this.asList(() -> this.get(TrelloUrl.createUrl("/boards/{boardId}/members/{memberId}/cards?").params(argsAndFilter).asString(), CardWithActions[].class, boardId, memberId));
    }

    @Override
    public List<Member> getBoardMemberships(String boardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/boards/{boardId}/memberships?").params(args).asString(), Member[].class, boardId));
    }

    @Override
    public MyPrefs getBoardMyPrefs(String boardId) {
        MyPrefs myPrefs = this.get(TrelloUrl.createUrl("/boards/{boardId}/myPrefs?").asString(), MyPrefs.class, boardId);
        myPrefs.setInternalTrello(this);
        return myPrefs;
    }

    @Override
    public Organization getBoardOrganization(String boardId, Argument ... args) {
        Organization organization = this.get(TrelloUrl.createUrl("/boards/{boardId}/organization?").params(args).asString(), Organization.class, boardId);
        organization.setInternalTrello(this);
        return organization;
    }

    @Override
    public Action getAction(String actionId, Argument ... args) {
        Action action = this.get(TrelloUrl.createUrl("/actions/{actionId}?").params(args).asString(), Action.class, actionId);
        action.setInternalTrello(this);
        return action;
    }

    @Override
    public Board getActionBoard(String actionId, Argument ... args) {
        Board board = this.get(TrelloUrl.createUrl("/actions/{actionId}/board?").params(args).asString(), Board.class, actionId);
        board.setInternalTrello(this);
        return board;
    }

    @Override
    public Card getActionCard(String actionId, Argument ... args) {
        Card card = this.get(TrelloUrl.createUrl("/actions/{actionId}/card?").params(args).asString(), Card.class, actionId);
        card.setInternalTrello(this);
        return card;
    }

    @Override
    public List<Entity> getActionEntities(String actionId) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/actions/{actionId}/entities?").asString(), Entity[].class, actionId));
    }

    @Override
    public TList getActionList(String actionId, Argument ... args) {
        TList tList = this.get(TrelloUrl.createUrl("/actions/{actionId}/list?").params(args).asString(), TList.class, actionId);
        tList.setInternalTrello(this);
        return tList;
    }

    @Override
    public Member getActionMember(String actionId, Argument ... args) {
        Member member = this.get(TrelloUrl.createUrl("/actions/{actionId}/member?").params(args).asString(), Member.class, actionId);
        member.setInternalTrello(this);
        return member;
    }

    @Override
    public Member getActionMemberCreator(String actionId, Argument ... args) {
        Member member = this.get(TrelloUrl.createUrl("/actions/{actionId}/memberCreator?").params(args).asString(), Member.class, actionId);
        member.setInternalTrello(this);
        return member;
    }

    @Override
    public Organization getActionOrganization(String actionId, Argument ... args) {
        Organization organization = this.get(TrelloUrl.createUrl("/actions/{actionId}/organization?").params(args).asString(), Organization.class, actionId);
        organization.setInternalTrello(this);
        return organization;
    }

    @Override
    public Card getCard(String cardId, Argument ... args) {
        Card card = this.get(TrelloUrl.createUrl("/cards/{cardId}?").params(args).asString(), Card.class, cardId);
        card.setInternalTrello(this);
        return card;
    }

    @Override
    public List<Action> getCardActions(String cardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/cards/{cardId}/actions?").params(args).asString(), Action[].class, cardId));
    }

    @Override
    public List<Attachment> getCardAttachments(String cardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/cards/{cardId}/attachments?").params(args).asString(), Attachment[].class, cardId));
    }

    @Override
    public List<Member> getCardMembers(String cardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/cards/{cardId}/members?").params(args).asString(), Member[].class, cardId));
    }

    @Override
    public Attachment getCardAttachment(String cardId, String attachmentId, Argument ... args) {
        Attachment attachment = this.get(TrelloUrl.createUrl("/cards/{cardId}/attachments/{attachmentId}?").params(args).asString(), Attachment.class, cardId, attachmentId);
        attachment.setInternalTrello(this);
        return attachment;
    }

    @Override
    public Board getCardBoard(String cardId, Argument ... args) {
        Board board = this.get(TrelloUrl.createUrl("/cards/{cardId}/board?").params(args).asString(), Board.class, cardId);
        board.setInternalTrello(this);
        return board;
    }

    @Override
    public void deleteCard(String cardId) {
        Objects.requireNonNull(cardId);
        this.delete(TrelloUrl.createUrlWithNoArgs("/cards/{cardId}?"), Map.class, cardId);
    }

    @Override
    public List<CheckList> getCardChecklists(String cardId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/cards/{cardId}/checklists?").params(args).asString(), CheckList[].class, cardId));
    }

    @Override
    public TList getList(String listId, Argument ... args) {
        TList tList = this.get(TrelloUrl.createUrl("/lists/{listId}?").params(args).asString(), TList.class, listId);
        tList.setInternalTrello(this);
        return tList;
    }

    @Override
    public List<Card> getListCards(String listId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/lists/{listId}/cards?").params(args).asString(), Card[].class, listId));
    }

    @Override
    public List<Board> getOrganizationBoards(String organizationId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/organizations/{organizationId}/boards?").params(args).asString(), Board[].class, organizationId));
    }

    @Override
    public List<Member> getOrganizationMembers(String organizationId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/organizations/{organizationId}/members?").params(args).asString(), Member[].class, organizationId));
    }

    @Override
    public Label getLabel(String labelId, Argument ... args) {
        Label label = this.get(TrelloUrl.createUrl("/labels/{labelId}?").params(args).asString(), Label.class, labelId);
        return label.setInternalTrello(this);
    }

    @Override
    public Label createLabel(Label label) {
        Label createdLabel = this.postForObject(TrelloUrl.createUrlWithNoArgs("/labels?"), label, Label.class, new String[0]);
        return createdLabel.setInternalTrello(this);
    }

    @Override
    public Label updateLabel(Label label) {
        Label updatedLabel = this.put(TrelloUrl.createUrlWithNoArgs("/labels/{labelId}?"), label, Label.class, label.getId());
        return updatedLabel.setInternalTrello(this);
    }

    @Override
    public void deleteLabel(String labelId) {
        this.delete(TrelloUrl.createUrlWithNoArgs("/labels/{labelId}?"), Map.class, labelId);
    }

    @Override
    public CheckList getCheckList(String checkListId, Argument ... args) {
        CheckList checkList = this.get(TrelloUrl.createUrl("/checklists/{checkListId}?").params(args).asString(), CheckList.class, checkListId);
        checkList.setInternalTrello(this);
        return checkList;
    }

    @Override
    public CheckList createCheckList(String cardId, CheckList checkList) {
        checkList.setIdCard(cardId);
        CheckList createdCheckList = this.postForObject(TrelloUrl.createUrl("/checklists?").asString(), checkList, CheckList.class, new String[0]);
        createdCheckList.setInternalTrello(this);
        return createdCheckList;
    }

    @Override
    public void createCheckItem(String checkListId, CheckItem checkItem) {
        this.postForLocation(TrelloUrl.createUrl("/checklists/{checkListId}/checkitems?").asString(), checkItem, checkListId);
    }

    @Override
    public Card createCard(String listId, Card card) {
        card.setIdList(listId);
        try {
            Card createdCard = this.postForObject(TrelloUrl.createUrl("/cards?pos=top&").asString(), card, Card.class, new String[0]);
            createdCard.setInternalTrello(this);
            return createdCard;
        }
        catch (TrelloBadRequestException e) {
            throw TrelloImpl.decodeException(card, e);
        }
    }

    @Override
    public Card updateCard(Card card) {
        try {
            Card put = this.put(TrelloUrl.createUrl("/cards/{cardId}?").asString(), card, Card.class, card.getId());
            put.setInternalTrello(this);
            return put;
        }
        catch (TrelloBadRequestException e) {
            throw TrelloImpl.decodeException(card, e);
        }
    }

    private static TrelloBadRequestException decodeException(Card card, TrelloBadRequestException e) {
        if (e.getMessage().contains("invalid value for idList")) {
            return new ListNotFoundException(card.getIdList());
        }
        if (e instanceof NotFoundException) {
            return new NotFoundException("Card with id " + card.getId() + " is not found. It may have been deleted in Trello");
        }
        return e;
    }

    @Override
    @Deprecated
    public Member getBasicMemberInformation(String username) {
        Member member = this.get(TrelloUrl.createUrl("/members/{username}?").params(new Argument("fields", "username,fullName")).asString(), Member.class, username);
        member.setInternalTrello(this);
        return member;
    }

    @Override
    public Member getMemberInformation(String username) {
        Member member = this.get(TrelloUrl.createUrl("/members/{username}?").asString(), Member.class, username);
        member.setInternalTrello(this);
        return member;
    }

    @Override
    public List<Board> getMemberBoards(String userId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/members/{userId}/boards?").params(args).asString(), Board[].class, userId));
    }

    @Override
    public List<Card> getMemberCards(String userId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/members/{userId}/cards?").params(args).asString(), Card[].class, userId));
    }

    @Override
    public List<Action> getMemberActions(String userId, Argument ... args) {
        return this.asList(() -> this.get(TrelloUrl.createUrl("/members/{userId}/actions?").params(args).asString(), Action[].class, userId));
    }

    @Override
    public void addLabelsToCard(String idCard, String[] labels) {
        for (String labelName : labels) {
            Label label = new Label();
            label.setName(labelName);
            this.postForObject(TrelloUrl.createUrl("/cards/{cardId}/labels?").asString(), label, Label.class, idCard);
        }
    }

    @Override
    public List<String> addLabelToCard(String cardId, String labelId) {
        Objects.requireNonNull(cardId);
        Objects.requireNonNull(labelId);
        return Arrays.asList((Object[])this.postForObject(TrelloUrl.createUrlWithNoArgs("/cards/{cardId}/idLabels?"), Collections.singletonMap("value", labelId), String[].class, cardId));
    }

    @Override
    public void addCommentToCard(String idCard, String comment) {
        this.postForObject(TrelloUrl.createUrl("/cards/{cardId}/actions/comments?").asString(), new Comment(comment), Comment.class, idCard);
    }

    @Override
    public Action updateComment(String idCard, String commentActionId, String text) {
        return this.put(TrelloUrl.createUrlWithNoArgs("/cards/{cardId}/actions/{actionId}/comments?"), new Comment(text), Action.class, idCard, commentActionId);
    }

    @Override
    public void addAttachmentToCard(String idCard, File file) {
        this.postFileForObject(TrelloUrl.createUrl("/cards/{cardId}/attachments?").asString(), file, Attachment.class, idCard);
    }

    @Override
    public void addUrlAttachmentToCard(String idCard, String url) {
        this.postForObject(TrelloUrl.createUrl("/cards/{cardId}/attachments?").asString(), new Attachment(url), Attachment.class, idCard);
    }

    @Override
    public void deleteAttachment(String idCard, String attachmentId) {
        this.delete(TrelloUrl.createUrlWithNoArgs("/cards/{cardId}/attachments/{attachmentId}?"), Map.class, idCard, attachmentId);
    }

    @Override
    public List<Member> addMemberToCard(String idCard, String userId) {
        return this.asList(() -> this.postForObject(TrelloUrl.createUrl("/cards/{cardId}/idMembers?").asString(), Collections.singletonMap("value", userId), Member[].class, idCard));
    }

    @Override
    public List<Member> removeMemberFromCard(String idCard, String userId) {
        return this.asList(() -> this.delete(TrelloUrl.createUrl("/cards/{cardId}/idMembers/{idMember}?").asString(), Member[].class, idCard, userId));
    }

    private <T> T postFileForObject(String url, File file, Class<T> objectClass, String ... params) {
        logger.debug("PostFileForObject request on Trello API at url {} for class {} with params {}", new Object[]{url, objectClass.getCanonicalName(), params});
        return this.httpClient.postFileForObject(url, file, objectClass, this.enrichParams(params));
    }

    private <T> T postForObject(String url, Object object, Class<T> objectClass, String ... params) {
        logger.debug("PostForObject request on Trello API at url {} for class {} with params {}", new Object[]{url, objectClass.getCanonicalName(), params});
        return this.httpClient.postForObject(url, object, objectClass, this.enrichParams(params));
    }

    private void postForLocation(String url, Object object, String ... params) {
        logger.debug("PostForLocation request on Trello API at url {} for class {} with params {}", new Object[]{url, object.getClass().getCanonicalName(), params});
        this.httpClient.postForLocation(url, object, this.enrichParams(params));
    }

    private <T> T get(String url, Class<T> objectClass, String ... params) {
        logger.debug("Get request on Trello API at url {} for class {} with params {}", new Object[]{url, objectClass.getCanonicalName(), params});
        return this.httpClient.get(url, objectClass, this.enrichParams(params));
    }

    private <T> T put(String url, Object object, Class<T> objectClass, String ... params) {
        logger.debug("Put request on Trello API at url {} for class {} with params {}", new Object[]{url, object.getClass().getCanonicalName(), params});
        return this.httpClient.putForObject(url, object, objectClass, this.enrichParams(params));
    }

    private <T> T delete(String url, Class<T> responseType, String ... params) {
        logger.debug("Delete request on Trello API at url {} for class {} with params {}", new Object[]{url, responseType.getClass().getCanonicalName(), params});
        return this.httpClient.delete(url, responseType, this.enrichParams(params));
    }

    private String[] enrichParams(String[] params) {
        ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(params));
        paramList.add(this.applicationKey);
        paramList.add(this.accessToken);
        return paramList.toArray(new String[paramList.size()]);
    }

    private <T extends TrelloEntity> List<T> asList(Supplier<T[]> responseSupplier) {
        return Arrays.stream(responseSupplier.get()).peek(t -> t.setInternalTrello(this)).collect(Collectors.toList());
    }
}

