/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.impl;

import com.julienvey.trello.Trello;
import com.julienvey.trello.TrelloHttpClient;
import com.julienvey.trello.domain.Action;
import com.julienvey.trello.domain.Argument;
import com.julienvey.trello.domain.Attachment;
import com.julienvey.trello.domain.Board;
import com.julienvey.trello.domain.Card;
import com.julienvey.trello.domain.CardWithActions;
import com.julienvey.trello.domain.CheckItem;
import com.julienvey.trello.domain.CheckList;
import com.julienvey.trello.domain.Entity;
import com.julienvey.trello.domain.Member;
import com.julienvey.trello.domain.MyPrefs;
import com.julienvey.trello.domain.Organization;
import com.julienvey.trello.domain.TList;
import com.julienvey.trello.impl.TrelloUrl;
import com.julienvey.trello.impl.domaininternal.Comment;
import com.julienvey.trello.impl.domaininternal.Label;
import com.julienvey.trello.impl.http.ApacheHttpClient;
import com.julienvey.trello.impl.http.RestTemplateHttpClient;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrelloImpl
implements Trello {
    private TrelloHttpClient httpClient;
    private String applicationKey;
    private String accessToken;
    private static Logger logger = LoggerFactory.getLogger(TrelloImpl.class);

    public TrelloImpl(String applicationKey, String accessToken) {
        this(applicationKey, accessToken, new RestTemplateHttpClient());
    }

    public TrelloImpl(String applicationKey, String accessToken, TrelloHttpClient httpClient) {
        this.applicationKey = applicationKey;
        this.accessToken = accessToken;
        this.httpClient = httpClient;
    }

    @Override
    public Board getBoard(String boardId, Argument ... args) {
        Board board = this.get(TrelloUrl.createUrl("/boards/{boardId}?").params(args).asString(), Board.class, boardId);
        board.setInternalTrello(this);
        for (TList list : board.getLists()) {
            list.setInternalTrello(this);
        }
        return board;
    }

    @Override
    public List<Action> getBoardActions(String boardId, Argument ... args) {
        List<Object> actions = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/boards/{boardId}/actions?").params(args).asString(), Action[].class, boardId));
        for (Action action : actions) {
            action.setInternalTrello(this);
        }
        return actions;
    }

    @Override
    public List<Card> getBoardCards(String boardId, Argument ... args) {
        List<Object> cards = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/boards/{boardId}/cards?").params(args).asString(), Card[].class, boardId));
        for (Card card : cards) {
            card.setInternalTrello(this);
        }
        return cards;
    }

    @Override
    public Card getBoardCard(String boardId, String cardId, Argument ... args) {
        Card card = this.get(TrelloUrl.createUrl("/boards/{boardId}/cards/{cardId}?").params(args).asString(), Card.class, boardId, cardId);
        card.setInternalTrello(this);
        return card;
    }

    @Override
    public List<CheckList> getBoardChecklists(String boardId, Argument ... args) {
        List<Object> checkLists = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/boards/{boardId}/checklists?").params(args).asString(), CheckList[].class, boardId));
        for (CheckList checkList : checkLists) {
            checkList.setInternalTrello(this);
        }
        return checkLists;
    }

    @Override
    public List<com.julienvey.trello.domain.Label> getBoardLabels(String boardId, Argument ... args) {
        List<Object> labels = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/boards/{boardId}/labels?").params(args).asString(), com.julienvey.trello.domain.Label[].class, boardId));
        for (com.julienvey.trello.domain.Label label : labels) {
            label.setInternalTrello(this);
        }
        return labels;
    }

    @Override
    public List<TList> getBoardLists(String boardId, Argument ... args) {
        List<Object> tLists = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/boards/{boardId}/lists?").params(args).asString(), TList[].class, boardId));
        for (TList tList : tLists) {
            tList.setInternalTrello(this);
            for (Card card : tList.getCards()) {
                card.setInternalTrello(this);
            }
        }
        return tLists;
    }

    @Override
    public List<Member> getBoardMembers(String boardId, Argument ... args) {
        List<Object> members = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/boards/{boardId}/members?").params(args).asString(), Member[].class, boardId));
        for (Member member : members) {
            member.setInternalTrello(this);
        }
        return members;
    }

    @Override
    public List<Card> getBoardMemberCards(String boardId, String memberId, Argument ... args) {
        List<Object> cards = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/boards/{boardId}/members/{memberId}/cards?").params(args).asString(), Card[].class, boardId, memberId));
        for (Card card : cards) {
            card.setInternalTrello(this);
        }
        return cards;
    }

    @Override
    @Deprecated
    public List<CardWithActions> getBoardMemberActivity(String boardId, String memberId, String actionFilter, Argument ... args) {
        if (actionFilter == null) {
            actionFilter = "all";
        }
        Argument[] argsAndFilter = Arrays.copyOf(args, args.length + 1);
        argsAndFilter[args.length] = new Argument("actions", actionFilter);
        List<Object> cards = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/boards/{boardId}/members/{memberId}/cards?").params(argsAndFilter).asString(), CardWithActions[].class, boardId, memberId));
        for (Card card : cards) {
            card.setInternalTrello(this);
        }
        return cards;
    }

    @Override
    public List<Member> getBoardMembersInvited(String boardId, Argument ... args) {
        List<Object> members = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/boards/{boardId}/membersInvited?").params(args).asString(), Member[].class, boardId));
        for (Member member : members) {
            member.setInternalTrello(this);
        }
        return members;
    }

    @Override
    public MyPrefs getBoardMyPrefs(String boardId) {
        MyPrefs myPrefs = this.get(TrelloUrl.createUrl("/boards/{boardId}/myPrefs?").asString(), MyPrefs.class, boardId);
        myPrefs.setInternalTrello(this);
        return myPrefs;
    }

    @Override
    public Organization getBoardOrganization(String boardId, Argument ... args) {
        Organization organization = this.get(TrelloUrl.createUrl("/boards/{boardId}/organization?").params(args).asString(), Organization.class, boardId);
        organization.setInternalTrello(this);
        return organization;
    }

    @Override
    public Action getAction(String actionId, Argument ... args) {
        Action action = this.get(TrelloUrl.createUrl("/actions/{actionId}?").params(args).asString(), Action.class, actionId);
        action.setInternalTrello(this);
        return action;
    }

    @Override
    public Board getActionBoard(String actionId, Argument ... args) {
        Board board = this.get(TrelloUrl.createUrl("/actions/{actionId}/board?").params(args).asString(), Board.class, actionId);
        board.setInternalTrello(this);
        return board;
    }

    @Override
    public Card getActionCard(String actionId, Argument ... args) {
        Card card = this.get(TrelloUrl.createUrl("/actions/{actionId}/card?").params(args).asString(), Card.class, actionId);
        card.setInternalTrello(this);
        return card;
    }

    @Override
    public List<Entity> getActionEntities(String actionId) {
        List<Object> entities = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/actions/{actionId}/entities?").asString(), Entity[].class, actionId));
        for (Entity entity : entities) {
            entity.setInternalTrello(this);
        }
        return entities;
    }

    @Override
    public TList getActionList(String actionId, Argument ... args) {
        TList tList = this.get(TrelloUrl.createUrl("/actions/{actionId}/list?").params(args).asString(), TList.class, actionId);
        tList.setInternalTrello(this);
        return tList;
    }

    @Override
    public Member getActionMember(String actionId, Argument ... args) {
        Member member = this.get(TrelloUrl.createUrl("/actions/{actionId}/member?").params(args).asString(), Member.class, actionId);
        member.setInternalTrello(this);
        return member;
    }

    @Override
    public Member getActionMemberCreator(String actionId, Argument ... args) {
        Member member = this.get(TrelloUrl.createUrl("/actions/{actionId}/memberCreator?").params(args).asString(), Member.class, actionId);
        member.setInternalTrello(this);
        return member;
    }

    @Override
    public Organization getActionOrganization(String actionId, Argument ... args) {
        Organization organization = this.get(TrelloUrl.createUrl("/actions/{actionId}/organization?").params(args).asString(), Organization.class, actionId);
        organization.setInternalTrello(this);
        return organization;
    }

    @Override
    public Card getCard(String cardId, Argument ... args) {
        Card card = this.get(TrelloUrl.createUrl("/cards/{cardId}?").params(args).asString(), Card.class, cardId);
        card.setInternalTrello(this);
        return card;
    }

    @Override
    public List<Action> getCardActions(String cardId, Argument ... args) {
        List<Object> actions = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/cards/{cardId}/actions?").params(args).asString(), Action[].class, cardId));
        for (Action action : actions) {
            action.setInternalTrello(this);
        }
        return actions;
    }

    @Override
    public List<Attachment> getCardAttachments(String cardId, Argument ... args) {
        List<Object> attachments = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/cards/{cardId}/attachments?").params(args).asString(), Attachment[].class, cardId));
        for (Attachment attachment : attachments) {
            attachment.setInternalTrello(this);
        }
        return attachments;
    }

    @Override
    public Attachment getCardAttachment(String cardId, String attachmentId, Argument ... args) {
        Attachment attachment = this.get(TrelloUrl.createUrl("/cards/{cardId}/attachments/{attachmentId}?").params(args).asString(), Attachment.class, cardId, attachmentId);
        attachment.setInternalTrello(this);
        return attachment;
    }

    @Override
    public Board getCardBoard(String cardId, Argument ... args) {
        Board board = this.get(TrelloUrl.createUrl("/cards/{cardId}/board?").params(args).asString(), Board.class, cardId);
        board.setInternalTrello(this);
        return board;
    }

    @Override
    public List<CheckList> getCardChecklists(String cardId, Argument ... args) {
        List<Object> checkLists = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/cards/{cardId}/checklists?").params(args).asString(), CheckList[].class, cardId));
        for (CheckList checkList : checkLists) {
            checkList.setInternalTrello(this);
        }
        return checkLists;
    }

    @Override
    public TList getList(String listId, Argument ... args) {
        TList tList = this.get(TrelloUrl.createUrl("/lists/{listId}?").params(args).asString(), TList.class, listId);
        tList.setInternalTrello(this);
        return tList;
    }

    @Override
    public List<Card> getListCards(String listId, Argument ... args) {
        List<Object> cards = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/lists/{listId}/cards?").params(args).asString(), Card[].class, listId));
        for (Card card : cards) {
            card.setInternalTrello(this);
        }
        return cards;
    }

    @Override
    public List<Board> getOrganizationBoards(String organizationId, Argument ... args) {
        List<Object> boards = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/organizations/{organizationId}/boards?").params(args).asString(), Board[].class, organizationId));
        for (Board board : boards) {
            board.setInternalTrello(this);
        }
        return boards;
    }

    @Override
    public List<Member> getOrganizationMembers(String organizationId, Argument ... args) {
        List<Object> members = Arrays.asList((Object[])this.get(TrelloUrl.createUrl("/organizations/{organizationId}/members?").params(args).asString(), Member[].class, organizationId));
        for (Member member : members) {
            member.setInternalTrello(this);
        }
        return members;
    }

    @Override
    public CheckList getCheckList(String checkListId, Argument ... args) {
        CheckList checkList = this.get(TrelloUrl.createUrl("/checklists/{checkListId}?").params(args).asString(), CheckList.class, checkListId);
        checkList.setInternalTrello(this);
        return checkList;
    }

    @Override
    public CheckList createCheckList(String cardId, CheckList checkList) {
        checkList.setIdCard(cardId);
        CheckList createdCheckList = this.postForObject(TrelloUrl.createUrl("/checklists?").asString(), checkList, CheckList.class, new String[0]);
        createdCheckList.setInternalTrello(this);
        return createdCheckList;
    }

    @Override
    public void createCheckItem(String checkListId, CheckItem checkItem) {
        this.postForLocation(TrelloUrl.createUrl("/checklists/{checkListId}/checkitems?").asString(), checkItem, checkListId);
    }

    @Override
    public Card createCard(String listId, Card card) {
        card.setIdList(listId);
        Card createdCard = this.postForObject(TrelloUrl.createUrl("/cards?pos=top&").asString(), card, Card.class, new String[0]);
        createdCard.setInternalTrello(this);
        return createdCard;
    }

    @Override
    @Deprecated
    public Member getBasicMemberInformation(String username) {
        Member member = this.get(TrelloUrl.createUrl("/members/{username}?").params(new Argument("fields", "username,fullName")).asString(), Member.class, username);
        member.setInternalTrello(this);
        return member;
    }

    @Override
    public Member getMemberInformation(String username) {
        Member member = this.get(TrelloUrl.createUrl("/members/{username}?").asString(), Member.class, username);
        member.setInternalTrello(this);
        return member;
    }

    @Override
    public void addLabelsToCard(String idCard, String[] labels) {
        for (String label : labels) {
            this.postForLocation(TrelloUrl.createUrl("/cards/{cardId}/labels?").asString(), new Label(label), idCard);
        }
    }

    @Override
    public void addCommentToCard(String idCard, String comment) {
        this.postForObject(TrelloUrl.createUrl("/cards/{cardId}/actions/comments?").asString(), new Comment(comment), Comment.class, idCard);
    }

    @Override
    public void addAttachmentToCard(String idCard, File file) {
        this.postFileForObject(TrelloUrl.createUrl("/cards/{cardId}/attachments?").asString(), file, Attachment.class, idCard);
    }

    @Override
    public void addUrlAttachmentToCard(String idCard, String url) {
        this.postForObject(TrelloUrl.createUrl("/cards/{cardId}/attachments?").asString(), new Attachment(url), Attachment.class, idCard);
    }

    @Override
    public Card updateCard(Card card) {
        Card put = this.put(TrelloUrl.createUrl("/cards/{cardId}?").asString(), card, Card.class, card.getId());
        put.setInternalTrello(this);
        return put;
    }

    private <T> T postFileForObject(String url, File file, Class<T> objectClass, String ... params) {
        logger.debug("PostFileForObject request on Trello API at url {} for class {} with params {}", new Object[]{url, objectClass.getCanonicalName(), params});
        if (!(this.httpClient instanceof ApacheHttpClient)) {
            throw new IllegalStateException("postForFile is implemented only on ApacheHttpClient.");
        }
        return ((ApacheHttpClient)this.httpClient).postFileForObject(url, file, objectClass, this.enrichParams(params));
    }

    private <T> T postForObject(String url, T object, Class<T> objectClass, String ... params) {
        logger.debug("PostForObject request on Trello API at url {} for class {} with params {}", new Object[]{url, objectClass.getCanonicalName(), params});
        return this.httpClient.postForObject(url, object, objectClass, this.enrichParams(params));
    }

    private void postForLocation(String url, Object object, String ... params) {
        logger.debug("PostForLocation request on Trello API at url {} for class {} with params {}", new Object[]{url, object.getClass().getCanonicalName(), params});
        this.httpClient.postForLocation(url, object, this.enrichParams(params));
    }

    private <T> T get(String url, Class<T> objectClass, String ... params) {
        logger.debug("Get request on Trello API at url {} for class {} with params {}", new Object[]{url, objectClass.getCanonicalName(), params});
        return this.httpClient.get(url, objectClass, this.enrichParams(params));
    }

    private <T> T put(String url, T object, Class<T> objectClass, String ... params) {
        logger.debug("Put request on Trello API at url {} for class {} with params {}", new Object[]{url, object.getClass().getCanonicalName(), params});
        return this.httpClient.putForObject(url, object, objectClass, this.enrichParams(params));
    }

    private String[] enrichParams(String[] params) {
        ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(params));
        paramList.add(this.applicationKey);
        paramList.add(this.accessToken);
        return paramList.toArray(new String[paramList.size()]);
    }
}

